Name: fish
Version: 3.0.2
Release: alt1

Summary: A friendly interactive shell
License: GPLv2+
Group: Shells

URL: http://fishshell.com/

# https://github.com/fish-shell/fish-shell.git
Source: %name-%version.tar

Requires: man
BuildRequires(pre): rpm-build-python3
BuildRequires: libncurses-devel doxygen gcc-c++
BuildRequires: libpcre2-devel >= 10.22

%set_compress_topdir %_mandir

%description
fish is a shell geared towards interactive use. Its features are
focused on user friendliness and discoverability. The language syntax
is simple but incompatible with other shell languages.

%prep
%setup
echo "%version" > version

rm -vrf pcre2-*

# Change the bundled scripts to invoke the python binary directly.
for f in $(find share/tools -type f -name '*.py'); do
    sed -i -e '1{s@^#!.*@#!%{__python3}@}' "$f"
done


%build
%autoreconf
%configure \
	--with-doxygen \
	--without-included-pcre2
%make_build

%install
%makeinstall_std
%find_lang %name

rm -f %buildroot%_datadir/fish/completions/docker.fish

%post
grep -q %_bindir/fish %_sysconfdir/shells ||
	echo %_bindir/fish >>%_sysconfdir/shells

%postun
. shell-quote
if [ "$1" = 0 ]; then
	sed -i "/^$(quote_sed_regexp %_bindir/fish)$/ d" %_sysconfdir/shells
fi

%files -f %name.lang
%_bindir/*
%dir %_sysconfdir/fish
%config %_sysconfdir/fish/config.fish
%_datadir/fish
%doc %_docdir/%name
%_man1dir/*

%changelog
