%define flacdocs %_docdir/%name
%define soversion 8
%define cppsoversion 6

%set_verify_elf_method textrel=relaxed

Name: flac
Version: 1.3.3
Release: alt1

Summary: Free Lossless Audio Codec
License: GPL-2.0-or-later and BSD-3-Clause and GFDL-1.1-or-later
Group: Sound
Url: https://xiph.org/flac/download.html
Source: %name-%version.tar
Patch: %name-%version-%release.patch

Requires: lib%name%soversion = %version-%release

%def_disable static
%{?_enable_static:BuildRequires: glibc-devel-static}

# Automatically added by buildreq on Fri Mar 25 2011
BuildRequires: docbook-utils doxygen gcc-c++ libogg-devel

%description
FLAC (%url) is an Open Source lossless audio codec.

%package -n lib%name%soversion
Summary: FLAC shared library
Group: System/Libraries
License: BSD-3-Clause
Provides: lib%name = %version

%description -n lib%name%soversion
The lib%name package contains a shared library of
functions for manipulating FLAC format audio files.

%package -n lib%name-devel
Summary: Development files for FLAC
Group: Development/C
License: BSD-3-Clause and GFDL-1.1-or-later
Requires: lib%name%soversion = %version-%release
Provides: liboggflac-devel = %version
Obsoletes: liboggflac-devel < %version

%description -n lib%name-devel
This package contains development files required for packaging
FLAC-based software.

%package -n lib%name-devel-static
Summary: Static libraries for FLAC
Group: Development/C
License: BSD-3-Clause
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains development libraries required for packaging
statically linked FLAC-based software.

%package -n lib%name++%cppsoversion
Summary: Object shared library FLAC++
Group: System/Libraries
License: BSD-3-Clause
Requires: lib%name%soversion = %version-%release
Provides: lib%name++ = %version

%description -n lib%name++%cppsoversion
The lib%name++%cppsoversion package contains a object wrapper library
of functions for manipulating FLAC format audio files.

%package -n lib%name++-devel
Summary: Development files for FLAC++ library
Group: Development/C
License: BSD-3-Clause
Requires: lib%name++%cppsoversion = %version-%release
Provides: liboggflac++-devel = %version
Obsoletes: liboggflac++-devel < %version

%description -n lib%name++-devel
This package contains development files required for packaging
FLAC++-based software.

%package -n lib%name++-devel-static
Summary: Static libraries for FLAC++ library
Group: Development/C
License: BSD-3-Clause
Requires: lib%name++-devel = %version-%release

%description -n lib%name++-devel-static
This package contains development libraries required for packaging
statically linked FLAC++-based software.

%prep
%setup
%patch -p1

%build
touch config.rpath
%autoreconf
%configure \
	%{?!_with_bootstrap:--enable-exhaustive-tests} \
	%{subst_enable static} \
#
%make_build

%install
%makeinstall
install -pm644 COPYING.Xiph AUTHORS README %buildroot%flacdocs/

%check
%make_build -k check

%files
%_bindir/*
%_mandir/man?/*
%flacdocs/
%exclude %flacdocs/[ACR]*

%files -n lib%name%soversion
%_libdir/libFLAC.so.*
%dir %flacdocs/
%flacdocs/AUTHORS
%flacdocs/README
%flacdocs/COPYING.Xiph

%files -n lib%name-devel
%_aclocaldir/libFLAC.m4
%_libdir/libFLAC.so
%_includedir/FLAC/
%_pkgconfigdir/flac.pc
%dir %flacdocs/
%flacdocs/api/

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libFLAC.a
%endif

%files -n lib%name++%cppsoversion
%_libdir/libFLAC++.so.*

%files -n lib%name++-devel
%_datadir/aclocal/libFLAC++.m4
%_libdir/libFLAC++.so
%_includedir/FLAC++
%_pkgconfigdir/flac++.pc

%if_enabled static
%files -n lib%name++-devel-static
%_libdir/libFLAC++.a
%endif

%changelog
