%define _localstatedir %_var
%define _libexecdir %_prefix/libexec
%define _userunitdir %_prefix/lib/systemd/user

%define xdg_name org.freedesktop.Flatpak
%define api_ver 1.0

# peer to peer support requires ostree >= 2018.2 with experimental/P2P API
%def_disable p2p
%def_enable docs
%def_with system_dbus_proxy
# cannot run bwrap in hasher
%def_disable check

Name: flatpak
Version: 1.6.3
Release: alt1

Summary: Application deployment framework for desktop apps
Group: Development/Tools
License: LGPLv2.1+
Url: http://flatpak.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/flatpak/flatpak/releases/download/%version/%name-%version.tar.xz
Source: %name-%version.tar

%define flatpak_group %name
%define flatpak_user %name

%define ostree_ver 2018.9
%define bwrap_ver 0.4.1
%define libarchive_ver 2.8.0

Requires: lib%name = %version-%release
Requires: %_bindir/fusermount
Requires: %_bindir/bwrap
Requires: bubblewrap >= %bwrap_ver
%{?_with_system_dbus_proxy:Requires: xdg-dbus-proxy}
Requires: ostree
Requires: dconf
Requires: fuse

BuildRequires: gtk-doc gobject-introspection-devel
BuildRequires: pkgconfig(gio-unix-2.0)
BuildRequires: pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(libarchive) >= %libarchive_ver
BuildRequires: pkgconfig(libsoup-2.4)
BuildRequires: pkgconfig(ostree-1) >= %ostree_ver
BuildRequires: pkgconfig(polkit-gobject-1)
BuildRequires: pkgconfig(libseccomp)
BuildRequires: pkgconfig(appstream-glib)
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(xau)
BuildRequires: pkgconfig(dbus-1)
BuildRequires: pkgconfig(systemd)
BuildRequires: pkgconfig(dconf)
BuildRequires: libattr-devel
BuildRequires: libcap-devel
BuildRequires: libgpgme-devel
BuildRequires: libfuse-devel
BuildRequires: udev-rules
BuildRequires: %_bindir/bwrap
BuildRequires: bubblewrap >= %bwrap_ver
%{?_with_system_dbus_proxy:BuildRequires: xdg-dbus-proxy}
BuildRequires: %_bindir/xsltproc
%{?_enable_docs:BuildRequires: %_bindir/xmlto docbook-dtds docbook-style-xsl}
BuildRequires: /proc
%{?_enable_check:BuildRequires: dbus %_bindir/fusermount %_bindir/ostree}

%description
Flatpak is a system for building, distributing and running sandboxed desktop
applications on Linux. See https://wiki.gnome.org/Projects/SandboxedApps for
more information.

%package -n lib%name
Summary: Libraries for %name
Group: Development/Other
License: LGPLv2+
Requires: %_bindir/bwrap

%description -n lib%name
This package contains libflatpak.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/Other
License: LGPLv2+
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the pkg-config file and development headers for %name.


%prep
%setup

%build
# workaround for collision with new copy_file_range glibc function. remove it when it's no longer needed.
#%%add_optflags -DHAVE_DECL_COPY_FILE_RANGE
# User namespace support is sufficient.
%configure --with-priv-mode=none \
           --with-system-bubblewrap \
           %{?_enable_docs:--enable-docbook-docs} \
           --with-systemdsystemunitdir=%_unitdir \
           --with-systemduserunitdir=%_userunitdir \
           %{?_with_system_dbus_proxy:DBUS_PROXY=%_bindir/xdg-dbus-proxy}
%nil
%make_build

%install
%makeinstall_std
# The system repo is not installed by the flatpak build system.
install -d %buildroot%_localstatedir/lib/flatpak

%find_lang %name

%pre
%_sbindir/groupadd -r -f %flatpak_group 2>/dev/null ||:
%_sbindir/useradd -r -n -g %flatpak_group -d / \
	-s /sbin/nologin -c "User for flatpak system helper" %flatpak_user 2>/dev/null ||:

%post
# Create an (empty) system-wide repo.
%_bindir/flatpak remote-list --system

%check
%make check

%files -f %name.lang
%_bindir/%name
%_bindir/%name-bisect
%_bindir/%name-coredumpctl
%_datadir/bash-completion
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/system-services/%xdg_name.SystemHelper.service
# Co-own directory.
%_datadir/gdm/env.d
%_datadir/%name
%_datadir/polkit-1/actions/%xdg_name.policy
%_datadir/polkit-1/rules.d/%xdg_name.rules
%_libexecdir/%name-portal
%{?_without_system_dbus_proxy:%_libexecdir/%name-dbus-proxy}
%_libexecdir/%name-session-helper
%_libexecdir/%name-system-helper
%_libexecdir/%name-validate-icon
%_libexecdir/revokefs-fuse
%dir %_localstatedir/lib/%name
%_man1dir/%{name}*.1*
%_sysconfdir/dbus-1/system.d/%xdg_name.SystemHelper.conf
%_datadir/dbus-1/interfaces/org.freedesktop.portal.Flatpak.xml
%_datadir/dbus-1/services/org.freedesktop.portal.Flatpak.service
%_sysconfdir/profile.d/%name.sh
%_unitdir/%name-system-helper.service
%_userunitdir/%name-portal.service
%_userunitdir/%name-session-helper.service
%_prefix/lib/systemd/user-environment-generators/60-%name
%_prefix/lib/systemd/user/flatpak-oci-authenticator.service
%_libexecdir/%name-oci-authenticator
%_datadir/dbus-1/interfaces/org.freedesktop.Flatpak.Authenticator.xml
%_datadir/dbus-1/services/org.flatpak.Authenticator.Oci.service
%_man5dir/*
%doc NEWS README.md
%{?_enable_docs:%doc %_docdir/%name/}

%files -n lib%name
%_libdir/lib%name.so.*
%_typelibdir/Flatpak-%api_ver.typelib

%files -n lib%name-devel
%_includedir/%name/
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc
%_datadir/dbus-1/interfaces/%xdg_name.xml
%_girdir/Flatpak-%api_ver.gir
%doc %_datadir/gtk-doc/html/%name


%changelog
