%def_disable snapshot

%define api_ver 2
%define sover %api_ver

%def_disable static
%def_disable ladcca
%def_enable lash
%def_enable ladspa
%def_enable jack
%def_enable pulseaudio
%def_disable portaudio
%def_enable dbus
%def_enable check

Name: fluidsynth
Version: 2.0.7
Release: alt1

Summary: Software real-time synthesizer
Summary(ru_RU.UTF-8): Программный синтезатор, работающий в режиме реального времени
Group: Sound
URL: http://www.fluidsynth.org
License: LGPL2.1+

%if_disabled snapshot
Source: https://github.com/FluidSynth/%name/archive/v%version/%name-%version.tar.gz
%else
# VCS: https://github.com/FluidSynth/fluidsynth.git
Source: %name-%version.tar
%endif

Requires: lib%name = %version-%release

%define cmake_ver 3.0.2
%define jack_ver 0.75.0
%define ladcca_ver 0.4.0
%define alsa_ver 0.9.8-alt2

BuildRequires: cmake >= %cmake_ver gcc-c++
BuildRequires: doxygen graphviz xsltproc docbook-dtds docbook-style-xsl
BuildRequires: glib2-devel libsndfile-devel libalsa-devel >= %alsa_ver libe2fs-devel
BuildRequires: libncurses-devel libreadline-devel
%{?_enable_ladcca:BuildRequires: libladcca-devel >= %ladcca_ver}
%{?_enable_lash:BuildRequires: liblash-devel}
%{?_enable_ladspa:BuildRequires: ladspa_sdk}
%{?_enable_jack:BuildRequires: libjack-devel >= %jack_ver}
%{?_enable_pulseaudio:BuildRequires: libpulseaudio-devel}
%{?_enable_dbus:BuildRequires: libdbus-devel}
%{?_enable_portaudio:BuildRequires: libportaudio-devel}
%{?_enable_check:BuildRequires: ctest}

%description
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

%description -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

%package -n lib%name
Summary: Shared libraries for %name
Summary(ru_RU.UTF-8): Разделяемые библиотеки для %name
Group: System/Libraries

%description -n lib%name
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains libraries for %name package

%description -n lib%name -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

Этот пакет содержит разделяемые библиотеки, необходимые для работы %name

%package -n lib%name-devel
Summary: Development environment for %name
Summary(ru_RU.UTF-8): Среда разработки для %name
Group: Development/C

%description -n lib%name-devel
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains headers and development files for lib%name package

%description -n lib%name-devel -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

Этот пакет содержит файлы, необходимы для разработки с использованием 
%name

%package -n lib%name-devel-static
Summary: Static %name library
Summary(ru_RU.UTF-8): Статические библиотеки для %name
Group: Development/C
Obsoletes: libiiwusynth-devel-static
Provides: libiiwusynth-devel-static = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains static libraries for %name package

%description -n lib%name-devel-static -l ru_RU.UTF-8
FluidSynth -- это программный синтезатор, работающий в режиме реального
времени и основанный на спецификациях Soundfont 2.

FluidSynth считывает и обрабатывает MIDI-события из входного
MIDI-устройства. Иными словами, программа является программным аналогом
MIDI-синтезатора. FluidSynth также может воспроизводить MIDI-файлы,
используя Soundfont.

Этот пакет содержит статические библиотеки для %name

%prep
%setup

%build
%cmake \
    -DLIB_INSTALL_DIR:PATH=%_lib \
    -DINCLUDE_INSTALL_DIR:PATH=include \
    -DDEFAULT_SOUNDFONT:STRING="%_datadir/soundfonts/default.sf2" \
    -DCMAKE_BUILD_TYPE:STRING="Release" \
    %{?_enable_lash:-Denable-lash:bool=true} \
    %{?_enable_ladcca:-Denable-ladcca:bool=true} \
    %{?_enable_ladspa:-Denable-ladspa:bool=true} \
    %{?_enable_jack:-Denable-jack:bool=true} \
    %{?_enable_pulseaudio:-Denable-pulseaudio:bool=true} \
    %{?_enable_dbus:-Denable-dbus:bool=true} \
    %{?_enable_portaudio:-Denable-portaudio:bool=true} \

%cmake_build
%cmake_build doxygen

%install
%cmakeinstall_std
cp -r BUILD/doc/api/html ./

%check
%make -C BUILD check

%files
%_bindir/%name
%_man1dir/%name.1.*

%files -n lib%name
%_libdir/lib%name.so.*
%doc AUTHORS README.md THANKS NEWS

%files -n lib%name-devel
%_includedir/*
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc
%doc html
%doc TODO

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
