%define        pkgname fog

Name:          %pkgname
Version:       2.2.0
Release:       alt1
Summary:       The Ruby cloud services library
License:       MIT
Group:         Development/Other
Url:           http://fog.io
%vcs           https://github.com/fog/fog.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
%gem_replace_version fog-brightbox ~> 1.0

%description
fog is the Ruby cloud services library, top to bottom:

- Collections provide a simplified interface, making clouds easier to
  work with and switch between.
- Requests allow power users to get the most out of the features of each
  individual cloud.
- Mocks make testing and integrating a breeze.


%package       -n gem-%pkgname
Summary:       Library files for %gemname gem
Group:         Development/Ruby
BuildArch:     noarch

%description   -n gem-%pkgname
Library files for %gemname gem.


%package       -n gem-%pkgname-doc
Summary:       Documentation files for %gemname gem
Group:         Development/Documentation
BuildArch:     noarch
Provides:      fog-doc
Obsoletes:     fog-doc

%description   -n gem-%pkgname-doc
Documentation files for %gemname gem.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README*
%_bindir/%name

%files         -n gem-%pkgname
%ruby_gemspec
%ruby_gemlibdir

%files         -n gem-%pkgname-doc
%ruby_gemdocdir


%changelog
