Group: System/Fonts/True type
%define oldname baekmuk-bdf-fonts
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: fontpackages-devel
%global fontname   baekmuk-bdf

%global fontdir      %_bitmapfontsdir/%{fontname}
%global catalogue    %{_sysconfdir}/X11/fontpath.d

Name:           fonts-bitmap-baekmuk
Version:        2.2
Release:        alt3_24
Summary:        Korean bitmap fonts

License:        Baekmuk
URL:            http://kldp.net/projects/baekmuk/
Source:  http://kldp.net/frs/download.php/1428/%{fontname}-%{version}.tar.gz
Patch0:	 baekmuk-bdf-fonts-fix-fonts-alias.patch
BuildArch:      noarch
BuildRequires:  bdftopcf mkfontdir mkfontscale xorg-font-utils
Source44: import.info

%description
This package provides the Korean Baekmuk bitmap fonts.


%prep
%setup -q -n %{fontname}-%{version}
%patch0 -p1 -b .fix-fonts-alias

%build
for file in bdf/*.bdf; do
    bdftopcf $file | gzip -9 > ${file%.bdf}.pcf.gz
done

%install

install -d $RPM_BUILD_ROOT%{fontdir}

# for bmp font
install -m 0644 bdf/*.pcf.gz $RPM_BUILD_ROOT%{fontdir}/
install -m 0444 bdf/fonts.alias $RPM_BUILD_ROOT%{fontdir}/

# for catalogue
install -d $RPM_BUILD_ROOT%{catalogue}
ln -sf ../../..%{fontdir} $RPM_BUILD_ROOT%{catalogue}/%{oldname}

mkfontdir $RPM_BUILD_ROOT%{fontdir} 

# convert Korean copyright file to utf8
iconv -f EUC-KR -t UTF-8 COPYRIGHT.ks > COPYRIGHT.ko

%files
%doc COPYRIGHT COPYRIGHT.ko README
%dir %{fontdir}
%{fontdir}/*.gz
%{fontdir}/fonts.alias
%verify(not md5 size mtime) %{fontdir}/fonts.dir
%{catalogue}/*


%changelog
