%def_with bundled_libs
%def_without glvnd
%define oname freecad
%define ldir %_libdir/%oname
%ifndef build_parallel_jobs
%define build_parallel_jobs 7
%endif

# Last number in version is computed by command:
# git rev-list --count remotes/upstream/releases/FreeCAD-0-17

Name:    freecad
Version: 0.18.5
Release: alt0.1.p9.1
Epoch:   1
Summary: OpenSource 3D CAD modeller
License: LGPL-2.0+
Group:   Graphics
Url:     http://free-cad.sourceforge.net/
# VCS:   https://github.com/FreeCAD/FreeCAD
Packager: Andrey Cherepanov <cas@altlinux.org>

Source: %name-%version.tar
Source1: freecad.1

%if_without bundled_libs
Patch1: %name-remove-3rdParty.patch
Patch2: %name-build-with-external-smesh.patch
%endif

# branch releases/FreeCAD-0-17
#Patch3: upstream.patch
Patch4: %name-desktop-ru.patch

Patch5: %name-0.18.4-alt-boost-1.73.0-compat.patch
Patch6: %name-0.18.4-upstream-qt-5.15-compat-1.patch
Patch7: %name-0.18.4-upstream-qt-5.15-compat-2.patch
Patch8: %name-0.18.4-upstream-qt-5.15-compat-3.patch
Patch9: %name-0.18.4-upstream-qt-5.15-compat-4.patch
Patch10: %name-alt-ignore-macro-with-empty-name.patch 

Patch30: freecad-0.19.2-upstream-vtk9-compat.patch
Patch31: freecad-0.18.5-alt-link.patch
Patch32: freecad-0.18.5-upstream-vtk9-compat.patch

Provides:  free-cad = %version-%release
Obsoletes: free-cad < %version-%release

BuildRequires(pre): cmake
BuildRequires(pre): rpm-build-xdg
BuildRequires(pre): rpm-build-ninja
BuildRequires: qt5-base-devel
BuildRequires: qt5-assistant
BuildRequires: qt5-designer
BuildRequires: qt5-sql-sqlite3
BuildRequires: qt5-svg-devel
BuildRequires: qt5-tools-devel
BuildRequires: qt5-tools-devel-static
BuildRequires: qt5-webkit-devel
BuildRequires: qt5-x11extras-devel
BuildRequires: qt5-phonon-devel
BuildRequires: python-module-PySide2
BuildRequires: pyside2-tools-python2
BuildRequires: python-module-shiboken2-devel
%define qmake %qmake_qt5
%define qtbindir %_qt5_bindir
BuildRequires: python-devel swig gcc-fortran libf2c-ng-devel chrpath
BuildRequires: boost-devel
BuildRequires: boost-filesystem-devel
BuildRequires: boost-geometry-devel
BuildRequires: boost-polygon-devel
BuildRequires: boost-program_options-devel
BuildRequires: boost-python-devel
BuildRequires: boost-signals-devel
BuildRequires: libcoin3d-devel
#BuildRequires: libSoQt-devel
BuildRequires: zlib-devel
BuildRequires: libopencv2-devel libxerces-c-devel gcc-c++
BuildRequires: java-devel-default
BuildRequires: libXxf86misc-devel
BuildRequires: OCE-devel libgts-devel
BuildRequires: libode-devel libann-devel
BuildRequires: doxygen graphviz
BuildRequires: eigen3
#BuildRequires: python-module-pivy
BuildRequires: libnumpy-devel
BuildRequires: boost-interprocess-devel
BuildRequires: gdb
BuildRequires: libvtk-devel vtk-examples vtk-python3
BuildRequires: libhdf5-devel libhdf5-mpi-devel
BuildRequires: libmed-devel libspnav-devel
BuildRequires: python-module-matplotlib
BuildRequires: libkdtree++-devel
%if_without bundled_libs
BuildRequires: libsmesh-devel libnetgen-devel
%endif
%if_with glvnd
BuildRequires: libglvnd-devel
%else
Requires: libEGL-devel libGLU-devel
%endif
#BuildRequires: texlive-extra-utils

%py_requires pivy matplotlib.backends.backend_qt4
%py_provides Fem FreeCAD FreeCADGui Mesh Part MeshPart Drawing ImportGui
%py_provides PartGui Sketcher TestSketcherApp Robot RobotGui SketcherGui
%py_provides ImageGui PartDesignGui _PartDesign
%add_python_req_skip pyopencl IfcImport Units
%add_findreq_skiplist %ldir/Mod/*
Requires: openscad
Requires: python-module-GitPython

%description
FreeCAD will be a general purpose 3D CAD modeler. FreeCAD is aimed directly at
mechanical engineering and product design but also fits in a wider range of uses
around engineering, such as architecture or other engineering specialties.

FreeCAD features tools similar to Catia, SolidWorks or Solid Edge, and therefore
also falls into the category of MCAD, PLM, CAx and CAE. It will be a feature
based parametric modeler with a modular software architecture which makes it
easy to provide additional functionality without modifying the core system.

%package docs
Summary: Documentation for FreeCAD
Group: Documentation
#BuildArch: noarch
Provides:  free-cad-docs = %version-%release
Obsoletes: free-cad-docs < %version-%release
Requires: qt5-assistant

%description docs
FreeCAD will be a general purpose 3D CAD modeler. FreeCAD is aimed directly at
mechanical engineering and product design but also fits in a wider range of uses
around engineering, such as architecture or other engineering specialties.

FreeCAD features tools similar to Catia, SolidWorks or Solid Edge, and therefore
also falls into the category of MCAD, PLM, CAx and CAE. It will be a feature
based parametric modeler with a modular software architecture which makes it
easy to provide additional functionality without modifying the core system.

This package contains documentation for FreeCAD.

%prep
%setup
%if_without bundled_libs
# Removed bundled libraries
%patch1 -p1
%patch2 -p1
rm -rf src/3rdParty
%endif

#patch3 -p1
%patch4 -p1
#patch5 -p1
#patch6 -p1
#patch7 -p1
#patch8 -p1
#patch9 -p1
%patch10 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1

%build
export PATH=$PATH:%_qt5_bindir
%add_optflags -Wl,-rpath,%ldir/lib
%cmake_insource -GNinja \
-DCMAKE_BUILD_TYPE=Release \
-DCMAKE_INSTALL_DATADIR=%ldir \
-DCMAKE_INSTALL_DOCDIR=%ldir/doc \
-DCMAKE_INSTALL_LIBDIR=%ldir/lib \
-DOPENMPI_INCLUDE_DIRS=%_libdir/openmpi/include \
-DFREECAD_LIBPACK_USEPYSIDE=OFF \
-DBUILD_QT5=ON \
%if_without bundled_libs
-DFREECAD_USE_EXTERNAL_SMESH=ON \
-DSMESH_DIR=%_libdir \
-DSMESH_INCLUDE_DIR=%_includedir/smesh \
-DSMESH_VERSION_MAJOR=7 \
%endif
%if_with glvnd
-DOpenGL_GL_PREFERENCE=GLVND \
%endif
-DFREECAD_USE_EXTERNAL_PIVY=ON 

# Fix Unknown release and repository URL
sed -i 's,FCRevision      \"Unknown\",FCRevision      \"%{release} (Git)\",' src/Build/Version.h
sed -i 's,FCRepositoryURL \"Unknown\",FCRepositoryURL \"git://github.com/FreeCAD/FreeCAD.git master\",' src/Build/Version.h

export NPROCS=%build_parallel_jobs
%ninja_build

%install
%ninja_install

# binaries
mkdir -p %buildroot%ldir/bin
mv %buildroot%_bindir/* %buildroot%ldir/bin
ln -s ../%_lib/%name/bin/FreeCAD %buildroot%_bindir/freecad
ln -s ../%_lib/%name/bin/FreeCADCmd %buildroot%_bindir/freecadcmd
ln -s ../%_lib/%name/bin/FreeCAD %buildroot%_bindir/FreeCAD
ln -s ../%_lib/%name/bin/FreeCADCmd %buildroot%_bindir/FreeCADCmd

# icons
for size in 16 32 48 64
do
install -Dm0644 %buildroot%ldir/%name-icon-${size}.png %buildroot%_iconsdir/hicolor/${size}x${size}/apps/%name.png
done
install -Dm0644 %buildroot%ldir/%name.svg %buildroot%_iconsdir/hicolor/scalable/apps/%name.svg
install -Dm0644 %buildroot%ldir/%name.xpm %buildroot%_pixmapsdir/%name.xpm

# manpage
install -Dm0644 %SOURCE1 %buildroot%_man1dir/%name.1

# stuff
cp -af %buildroot%_prefix/Mod/* %buildroot%ldir/Mod
rm -rf %buildroot%_prefix/Mod
cp -af %buildroot%_prefix/Ext/ %buildroot%ldir/Ext
rm -rf %buildroot%_prefix/Ext

# l10n
%find_lang --with-kde %name

%files -f %name.lang
%doc ChangeLog.txt README.md
%doc %ldir/License.txt
%dir %ldir
%_bindir/*
%ldir/bin
%ldir/lib
%ldir/Gui
%ldir/Ext
%ldir/Mod
%ldir/examples
%ldir/*.png
%ldir/*.svg
%ldir/*.xpm
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/apps/%name.*
%_man1dir/*
%_xdgdatadir/mime/packages/*
%_pixmapsdir/%name.xpm
%_iconsdir/hicolor/scalable/apps/*.svg
%_datadir/metainfo/*.appdata.xml

%files docs
%ldir/doc

%changelog
