%def_disable snapshot
%def_disable static
%def_enable docs
%def_enable deprecated
%def_enable check

Name: fribidi
Version: 1.0.7
Release: alt1

Summary: Bi-directional scripts support
License: %lgpl21plus
Group: Development/C
Url: https://github.com/%name/%name/

%if_disabled snapshot
Source: %url/releases/download/v%version/%name-%version.tar.bz2
%else
#VCS: https://github.com/fribidi/fribidi.git
Source: %name-%version.tar
%endif

Requires: lib%name = %version-%release

BuildRequires(pre): meson rpm-build-licenses
%{?_enable_docs:BuildRequires: c2man}
%{?_enabled_static:BuildRequires: glibc-devel-static}

%package -n lib%name
Summary: Library implementing the Unicode BiDi algorithm
Group: System/Libraries

%package -n lib%name-devel
Summary: Library implementing the Unicode BiDi algorithm
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel

%description
Bi-directional scripts support.

%package -n lib%name-devel-static
Summary: Library implementing the Unicode BiDi algorithm
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name
A library to handle bidirectional scripts (eg hebrew, arabic), so that
the display is done in the proper way; while the text data itself is
always written in logical order.
The library uses unicode internally.

%description -n lib%name-devel
The libfribidi-devel package includes  header files
for the fribidi package.

Install libfribidi-devel if you want to develop programs which will use
fribidi.

%description -n lib%name-devel-static
The libfribidi-devel-static package includes the static libraries
for the fribidi package.

Install libfribidi-devel-static if you want to develop statically linked
programs which will use fribidi.

%prep
%setup

%build
%meson \
%{?_enable_static:--default-library=both} \
%{?_disable_deprecated:-Ddeprecated=false} \
%{?_disable_docs:-Ddocs=false} 
%nil
%meson_build

%install
%meson_install

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files
%_bindir/*
%doc README AUTHORS TODO THANKS NEWS
%{?_disable_snapshot:%doc ChangeLog}

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_pkgconfigdir/*.pc
%{?_enable_docs:%_man3dir/*.3*}

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
