%set_automake_version 1.10
%set_autoconf_version 2.60

%def_without libs

Name: fuse-encfs
Summary: Encrypted pass-thru filesystem for Linux
Version: 1.9.4
Release: alt3
License: GPL
Group: System/Kernel and hardware
Packager: Denis Smirnov <mithraen@altlinux.ru>

Source: %name.tar
Url: https://vgough.github.io/encfs/

Patch1: encfs.link.patch
Patch2: encfs.static.char.patch
Patch3: 0001-boost-serialization-version-workaround.patch

# Automatically added by buildreq on Mon Mar 20 2017
# optimized out: cmake-modules libcom_err-devel libkrb5-devel libstdc++-devel perl perl-Encode perl-Pod-Escapes perl-Pod-Simple perl-podlators pkg-config python-base
BuildRequires: cmake gcc-c++ libattr-devel libfuse-devel libssl-devel libtinyxml2-devel perl-Pod-Usage

BuildRequires: cvs

BuildRequires: libfuse-devel >= 2.1
BuildRequires: boost-devel boost-filesystem-devel

Requires: fuse
Requires: libssl >= 0.7.9g

Provides: encfs
Obsoletes: encfs

%description
EncFS implements an encrypted filesystem in userspace using FUSE.  FUSE
provides a Linux kernel module which allows virtual filesystems to be written
in userspace.  EncFS encrypts all data and filenames in the filesystem and
passes access through to the underlying filesystem.  Similar to CFS except that
it does not use NFS.

%prep
%setup -c %name-%version
## applied in upstream
#patch1 -p1
#patch2 -p2
## do we need it anymore???
#patch3 -p2

%build
mkdir -p build
cd build
%if_with libs
%cmake_insource -DINSTALL_LIBENCFS=ON -DBUILD_SHARED_LIBS=ON -DUSE_INTERNAL_TINYXML=OFF ..
%else
%cmake_insource -DINSTALL_LIBENCFS=OFF -DBUILD_SHARED_LIBS=OFF -DUSE_INTERNAL_TINYXML=OFF ..
%endif
%make_build

# Testing for correct build
#encfs/test

%install
cd build
%makeinstall_std
%find_lang encfs

%files -f build/encfs.lang
%_bindir/*
%_man1dir/*
%if_with libs
%_libdir/*.so.*
%exclude %_libdir/*.so
%endif

%changelog
