Name: fuse-sshfs
Version: 3.7.0
Release: alt2

Summary: SSH filesystem using FUSE
License: GPL-2.0-or-later
Group: System/Kernel and hardware
Url: https://github.com/libfuse/sshfs

# repacked https://github.com/libfuse/sshfs/releases/download/sshfs-%version/sshfs-%version.tar.xz
Source: sshfs-%version.tar
Source1: sshfs.watch
Patch1: alt-find-rst2man.patch

BuildRequires: libfuse3-devel >= 3.1.0 meson python3-module-docutils
Requires: ssh-provider-openssh-clients

Provides: sshfs-fuse = %version sshfs = %version
Obsoletes: sshfs-fuse < %version sshfs < %version

# Automatically added by buildreq on Wed Sep 26 2012
BuildRequires: glib2-devel libfuse-devel openssh-clients

%description
This is a filesystem client based on the SSH File Transfer Protocol. Since most
SSH servers already support this protocol it is very easy to set up: i.e. on
the server side there's nothing to do. On the client side mounting the 
filesystem is as easy as logging into the server with ssh.

The idea of sshfs was taken from the SSHFS filesystem distributed with LUFS,
which sshfs-fuse's author found very useful. There were some limitations of
that codebase, so he rewrote it. Features of this implementation are:

* Based on FUSE (the best userspace filesystem framework for linux ;-)
* Multithreading: more than one request can be on it's way to the server
* Allowing large reads (max 64k)
* Caching directory contents
* Reconnect on failure

%prep
%setup -q -n sshfs-%version
%patch1 -p1

%build
%meson
%meson_build

%install
%meson_install

%files
%doc AUTHORS README.rst
%_bindir/sshfs
%_sbindir/mount.sshfs
%_sbindir/mount.fuse.sshfs
%_man1dir/sshfs.*

%changelog
