Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires: perl(IO/Handle.pm)
# END SourceDeps(oneline)
%define oldname zfs-fuse
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _hardened_build 1
Name:             fuse-zfs
Version:          0.7.2.2
Release:          alt1_11
Summary:          ZFS ported to Linux FUSE
License:          CDDL
URL:              https://github.com/gordan-bobic/zfs-fuse
Source00:         http://github.com/gordan-bobic/zfs-fuse/archive/%{oldname}-%{version}.tar.gz
Source01:         zfs-fuse.service
Source02:         zfs-fuse.scrub
Source03:         zfs-fuse.sysconfig
Source04:         zfs-fuse-helper
Patch0:           zfs-fuse-0.7.2.2-stack.patch
Patch1:           zfs-fuse-0.7.2.2-python3.patch
Patch2:           tirpc.patch
BuildRequires:  gcc
BuildRequires:    libfuse-devel libaio-devel rpm-build-perl scons gcc-c++
BuildRequires:    zlib-devel libssl-devel libattr-devel liblzo2-devel bzlib-devel liblzma-devel
BuildRequires:    libtirpc-devel
%ifnarch aarch64 ppc64le
BuildRequires:    /usr/bin/execstack
%endif
BuildRequires:    libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-networkd systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils
Requires:         fuse >= 2.7.4
# (2010 karsten@redhat.com) zfs-fuse doesn't have s390(x) implementations for atomic instructions
ExcludeArch:      s390 s390x aarch64
# For compatibility for packages expecting slightly other locations
Provides:         /sbin/zfs
Provides:         /sbin/zpool
Provides:         /sbin/zdb
Provides:         /sbin/ztest
Provides:         /sbin/zstreamdump
Provides:         /sbin/mount.zfs
Source44: import.info
Source45: zfs-fuse.init

%description
ZFS is an advanced modern general-purpose filesystem from Sun
Microsystems, originally designed for Solaris/OpenSolaris.

This project is a port of ZFS to the FUSE framework for the Linux
operating system.

%prep
%setup -n %{oldname}-%{version} -q

%patch0 -p0
%patch1 -p1
%patch2 -p1

f=LICENSE
mv $f $f.iso88591
iconv -o $f -f iso88591 -t utf8 $f.iso88591
rm -f $f.iso88591

chmod -x contrib/test-datasets
chmod -x contrib/find-binaries
chmod -x contrib/solaris/fixfiles.py
chmod -x contrib/zfsstress.py
# cp -f /usr/lib/rpm/config.{guess,sub} src/lib/libumem/

%build
export CCFLAGS="%{optflags}"
pushd src

scons debug=2 optim='%{optflags}'

%install
pushd src
scons debug=1 install install_dir=%{buildroot}%{_sbindir} man_dir=%{buildroot}%{_mandir}/man8/ cfg_dir=%{buildroot}/%{_sysconfdir}/%{oldname}
install -Dp -m 0644 %{SOURCE1} %{buildroot}%{_unitdir}/%{oldname}.service
install -Dp -m 0755 %{SOURCE2} %{buildroot}%{_sysconfdir}/cron.weekly/98-%{oldname}-scrub
install -Dp -m 0644 %{SOURCE3} %{buildroot}%{_sysconfdir}/sysconfig/%{oldname}
install -Dp -m 0755 %{SOURCE4} %{buildroot}%{_sbindir}/zfs-fuse-helper

%ifnarch aarch64 ppc64le
#set stack not executable, BZ 911150
for i in zdb zfs zfs-fuse zpool ztest; do
       /usr/bin/execstack -c %{buildroot}%{_sbindir}/$i
done
%endif

mkdir -p -m 0755 %buildroot%_initdir
install -D -m 0755 %SOURCE45 %buildroot%_initdir/zfs-fuse

%post
oldcache=/etc/zfs/zpool.cache      # this changed per 0.6.9, only needed when upgrading from earlier versions
newcache=/var/lib/zfs/zpool.cache

if [[ -f $oldcache && ! -e $newcache ]]; then
  echo "Moving existing zpool.cache to new location"
  mkdir -p $(dirname $newcache)
  mv $oldcache $newcache
else
  if [ -e $oldcache ]; then
    echo "Note: old zpool.cache present but no longer used ($oldcache)"
  fi
fi

%post_service zfs-fuse

%preun
%preun_service zfs-fuse

%postun
echo "Removing files since we removed the last package"
rm -rf /var/run/zfs
rm -rf /var/lock/zfs

%files
%doc --no-dereference LICENSE
%doc BUGS CHANGES contrib HACKING README
%doc README.NFS STATUS TESTING TODO
%{_sbindir}/zdb
%{_sbindir}/zfs
%{_sbindir}/zfs-fuse
%{_sbindir}/zfs-fuse-helper
%{_sbindir}/zpool
%{_sbindir}/zstreamdump
%{_sbindir}/ztest
%{_sbindir}/mount.zfs
%{_unitdir}/%{oldname}.service
%{_sysconfdir}/cron.weekly/98-%{oldname}-scrub
%config(noreplace) %{_sysconfdir}/sysconfig/%{oldname}
%{_sysconfdir}/%{oldname}/
%{_mandir}/man8/zfs-fuse.8*
%{_mandir}/man8/zdb.8*
%{_mandir}/man8/zfs.8*
%{_mandir}/man8/zpool.8*
%{_mandir}/man8/zstreamdump.8*
%config(noreplace) %_initdir/zfs-fuse

%changelog
