Name: gear
Version: 2.5.0
Release: alt1

Summary: Get Every Archive from git package Repository
License: GPLv2+
Group: Development/Other
Url: http://www.altlinux.org/Gear
BuildArch: noarch

Source: %name-%version.tar

Requires: gear-sh-functions = %EVR

# due to gear-srpmimport.
Requires: faketime

# due to magic signature in pathspec.
Requires: git-core >= 0:1.9.0

# due to quote_shell_args()
Requires: libshell >= 0:0.1.0

# due to default output tarball compressor
Requires: tar >= 1.29.0.19.d061, zstd

# hasher>=1.0.30 supports tar packages made by gear utility.
Conflicts: hasher < 0:1.0.30

BuildPreReq: asciidoc, git-core >= 1.8.0, help2man, libshell >= 0:0.0.3-alt1
%{?!_without_check:%{?!_disable_check:BuildRequires: bzip2, gzip, faketime, unzip, xz, zip, zstd}}

%description
This package contains utilities for building RPM packages from GEAR
repositories and managing GEAR repositories.
See %_docdir/%name-%version/QUICKSTART.ru_RU.UTF-8 for details.

%package sh-functions
Summary: GEAR shell functions
Group: Development/Other
# git-core is optional
%filter_from_requires /^git-core/d

%description sh-functions
This package contains GEAR's shell functions.

%package -n describe-specfile
Summary: Print specfile name and version using gear's parser
Group: Development/Other
Requires: gear-sh-functions = %EVR

%description -n describe-specfile
This package contains utility which uses GEAR's spec parser to determine
specfile for its name and version info.

%prep
%setup

%build
%make_build
asciidoc docs/ABOUT.ru.utf8
asciidoc docs/QUICKSTART.ru.utf8

%check
make check

%install
%makeinstall_std
install -pDm644 contrib/gear-bash_completion \
	%buildroot/etc/bash_completion.d/gear
ln -s gear-store-tags %buildroot%_bindir/gear-update-tag
ln -s gear-store-tags.1 %buildroot%_man1dir/gear-update-tag.1

%define _unpackaged_files_terminate_build 1

%files
%config /etc/bash_completion.d/*
%_bindir/gear*
%exclude %_bindir/gear-sh-functions
%_datadir/%name
%_mandir/man?/gear*
%doc docs/QUICKSTART* docs/ABOUT*

%files sh-functions
%_bindir/gear-sh-functions

%files -n describe-specfile
%_bindir/describe-specfile*
%_man1dir/describe-specfile*

%changelog
