%def_disable snapshot

%define ver_major 3.32
%def_enable python
%def_enable zeitgeist
%define gedit_pluginsdir %_libdir/gedit/plugins
%add_python3_path %gedit_pluginsdir

Name: gedit-plugins
Version: %ver_major.0
Release: alt1

Summary: Plugins for GEdit
License: GPL
Group: Editors
Url: https://wiki.gnome.org/Apps/Gedit/ShippedPlugins

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.40.0
%define gtk_ver 3.14.0
%define gtksourceview_ver 4.0.2
%define gedit_ver 3.28.0
%define peas_ver 1.14
%define git2_ver 0.0.12
%define vte_ver 0.38

Requires: gedit >= %ver_major
Requires: libpeas-python3-loader
Requires: libvte3-gir >= %vte_ver
%{?_enable_zeitgeist:Requires: zeitgeist}

AutoReqProv: nopython
%define __python %nil

# From configure.ac
BuildRequires(pre): rpm-build-gir rpm-build-gnome
BuildRequires: gnome-common libappstream-glib-devel
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgtksourceview4-devel >= %gtksourceview_ver
BuildRequires: gedit-devel >= %gedit_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: yelp-tools
# for git plugin
BuildRequires: libgit2-glib-devel >= %git2_ver
# for Charmap plugin
BuildRequires: libgucharmap-devel >= 3.0.0 libgucharmap-gir-devel
%{?_enable_zeitgeist:BuildRequires: libzeitgeist2.0-devel libzeitgeist2.0-gir-devel}
%if_enabled python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3-devel
%endif
BuildRequires: libxml2-devel python3-module-dbus-devel libvte3-gir-devel

%description
gEdit is a small but powerful text editor designed expressly for GNOME.

It includes such features as split-screen mode, a plugin API, which
allows gEdit to be extended to support many features while remaining
small at its core, multiple document editing through the use of a
'tabbed' notebook and many more functions.

This package contains various plugins for gEdit, including Charmap, Terminal, and others.

%prep
%setup

%build
%autoreconf
%configure \
    --disable-static \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang gedit %name

%files -f %name.lang
%dir %_datadir/gedit/plugins
%_datadir/gedit/plugins/*
%gedit_pluginsdir/*
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.drawspaces.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.terminal.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.wordcompletion.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.translate.gschema.xml
%_datadir/metainfo/gedit-*.metainfo.xml
%exclude %gedit_pluginsdir/*.la

%changelog
