%define        pkgname gettext

Name:          gem-%pkgname
Version:       3.3.5
Release:       alt1
Summary:       Native Language Support Library for Ruby
Group:         Development/Ruby
License:       GPLv2
Url:           https://ruby-gettext.github.io/
Vcs:           https://github.com/ruby-gettext/locale.git
BuildArch:     noarch
Source:        %name-%version.tar

Obsoletes:     %name-cgi
Obsoletes:     %name-erb
Provides:      %name-cgi = %version-%release
Provides:      %name-erb = %version-%release

BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(kramdown)
BuildRequires: gem(racc)
BuildRequires: gem(rake)
# BuildRequires: gem(test-unit-notify)
BuildRequires: gem(test-unit)
# BuildRequires: gem(test-unit-rr)
BuildRequires: gem(yard)
BuildRequires: gem(locale)
BuildRequires: gem(text)

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
Ruby GetText Package is Native Language Support Library and Tools
which modeled after GNU gettext package.

Features:
 * Simple APIs(similar GNU gettext)
 * rgettext creates po-files from ruby scripts.
   The po-file is compatible to GNU gettext.
 * rmsgfmt creates a mo-file from a po-file.

This library was called as "Ruby-Locale". Since 2.0.6, this library is called
just "locale". You can call this library as "locale gem" or "Ruby Locale" to
distinguish from other "locale"s.

This library aims to support all environments which Ruby works and all kind of
programs (GUI, WWW, library, etc), and becomes the hub of other
i18n/l10n libs/apps to handle major locale ID standards.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       -n %pkgname-gemtools
Summary:       Ruby GetText Package CLI tools
Group:         Documentation
BuildArch:     noarch

Obsoletes:     tools < %EVR
Provides:      tools = %EVR

%description   -n %pkgname-gemtools
%summary.


%prep
%setup

%build
%ruby_build --use=%gemname --alias=%gemname-gemtools

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir

%files         -n %pkgname-gemtools
%_bindir/*

%files         doc
%ruby_gemdocdir

%changelog
