%define        pkgname pg

Name:          gem-%pkgname
Version:       1.2.3
Release:       alt1
Summary:       Ruby interface to PostgreSQL RDBMS
Group:         Development/Ruby
License:       BSD-2-Clause
Url:           https://bitbucket.org/ged/ruby-pg/
Vcs:           https://bitbucket.org/ged/ruby-pg.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(hoe)
BuildRequires: gem(rake-compiler)
BuildRequires: postgresql-devel
BuildRequires: uni2ascii

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-%pkgname < %EVR
Provides:      ruby-%pkgname = %EVR

%description
This is the extension library to access a PostgreSQL database
from Ruby. This library works with PostgreSQL 6.4-8.x; it
probably works with 6.3 or earlier with slight modification,
but not tested at all.


%package       doc
Summary:       Documentation files for %gemname gem
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета %gemname
Group:         Development/Documentation
BuildArch:     noarch

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%package       devel
Summary:       Development files for %gemname gem
Summary(ru_RU.UTF-8): Файлы для разработки на основе самоцвета %gemname
Group:         Development/Ruby
BuildArch:     noarch

Requires:      postgresql-devel

%description   devel
Development files for %gemname gem.

%description   devel -l ru_RU.UTF8
Файлы заголовков для самоцвета %gemname.


%prep
%setup

%build
%ruby_build --use=%gemname --version-replace=%version

%install
%ruby_install

%check
%ruby_test

%files
%doc README* LICENSE
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         doc
%ruby_gemdocdir

%files         devel
%ruby_includedir/*


%changelog
