%def_disable snapshot

%define ver_major 1.0
%define _libexecdir %_prefix/libexec

Name: genius
Version: %ver_major.24
Release: alt2

Summary: Genius Calculator
License: LGPLv3+
Group: Sciences/Mathematics
Url: http://www.jirka.org/genius.html

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 2.18.0
%define glib_ver 2.16.0
%define vte_ver 0.26.0
%define gtksourceview_ver 2.0.2
%define mpfr_ver 2.3.0

BuildPreReq: libgio-devel >= %glib_ver libgtk+2-devel >= %gtk_ver
BuildRequires: libgtksourceview-devel >= %gtksourceview_ver
BuildRequires: libreadline-devel libncurses-devel libgmp-devel libmpfr-devel >= %mpfr_ver
BuildRequires: autoconf-archive intltool xsltproc bison flex
# for non-UTF korean trnslation
BuildRequires: perl-Encode-KR
# since 1.0.24 internal vte used
# BuildRequires: libvte-devel >= %vte_ver

%description
Genius calculator is a general purpose calculator and mathematics tool
with many features.

See %url for more information.

%package devel
Summary: Genius development package
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description devel
Genius calculator is a general purpose calculator and mathematics tool
with many features.

This package provides headers needed to develop Genius plugins.

%prep
%setup
# stuff from newer (2.4.6) libtool
rm -f m4/*

subst '/GTK_UPDATE_ICON_CACHE/d' pixmaps/Makefile.am

%build
%autoreconf
%configure --disable-static \
	--disable-update-mimedb
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name

%check
%make check
pushd src
./geniustest.pl
popd

%files -f %name.lang
%_bindir/%name
%_bindir/gnome-%name
%_libexecdir/%name-readline-helper-fifo
%dir %_libdir/%name
%_libdir/%name/libtestplugin.so
%_datadir/application-registry/%name.applications
%_desktopdir/gnome-%name.desktop
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/gnome-%name.svg
%_datadir/mime/packages/%name.xml
%_datadir/mime-info/%name.keys
%_datadir/mime-info/%name.mime
%_datadir/%name/
%doc AUTHORS NEWS README TODO

%files devel
%_includedir/%name/

%exclude %_libdir/%name/*.la

%changelog
