%global import_path code.gitea.io/gitea

%global _unpackaged_files_terminate_build 1

Name:    gitea
Version: 1.12.6
Release: alt1

Summary: Git with a cup of tea, painless self-hosted git service

License: MIT
Group:   Development/Other
Url:     https://gitea.io

# https://github.com/go-gitea/gitea
Source:  %name-%version.tar

Source2: gitea.service
Source3: gitea.service.d.conf
Source4: README.ALT

Patch1: %name-%version.patch
Patch2: ALT_config.patch

BuildRequires(pre): rpm-build-golang
BuildRequires: golang >= 1.12 go-bindata
BuildRequires: npm >= 6.13.6-alt2 node >= 10.13
BuildRequires: libpam0-devel

Requires: git-core

%description
The goal of this project is to make the easiest, fastest, and most painless way
of setting up a self-hosted Git service. It is similar to GitHub, Bitbucket,
and Gitlab. Gitea is a fork of Gogs.

%prep
# build the JavaScript and CSS files
# $ npm install
# $ git add -f node_modules
# $ git commit -n --no-post-rewrite -m "add node js modules"

%setup
%patch1 -p1
%patch2 -p1

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"

TAGS="bindata sqlite sqlite_unlock_notify pam" GITEA_VERSION=%version %make all

%install
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_logdir/%name
install -Dm 0755 %name %buildroot%_bindir/%name
install -Dm 0644 %SOURCE2 %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_sysconfdir/systemd/system/gitea.service.d
install -Dm 0644 %SOURCE3 %buildroot%_sysconfdir/systemd/system/gitea.service.d/port.conf
install -Dm 0660 custom/conf/app.ini.sample %buildroot%_sysconfdir/%name/app.ini

# install docs
mkdir -p %buildroot%_docdir/%name
install -Dm 0644 custom/conf/app.ini.sample %buildroot%_docdir/%name/default-app.ini
install -Dm 0644 %SOURCE4 %buildroot%_docdir/%name/

%pre
groupadd -r -f %name 2>/dev/null ||:
useradd -r -g %name -c 'Gitea daemon' \
        -s /bin/bash  -d %_localstatedir/%name %name 2>/dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%_bindir/%name
%dir %attr(0750,%name,%name) %_localstatedir/%name
%dir %attr(0770,root,%name) %_logdir/%name
%dir %_docdir/%name
%dir %_sysconfdir/%name
%config(noreplace) %attr(0660,root,%name) %_sysconfdir/%name/app.ini
%config(noreplace) %_sysconfdir/systemd/system/gitea.service.d/port.conf
%dir %_sysconfdir/systemd/system/gitea.service.d
%_unitdir/%name.service
%_docdir/%name/default-app.ini
%_docdir/%name/README.ALT
%doc *.md

%changelog
