%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 2.60
%define api_ver 2.0
%define pcre_ver 8.31
%define gio_module_dir %_libdir/gio/modules

%set_verify_elf_method strict
%add_verify_elf_skiplist %_libexecdir/installed-tests/glib/*

%def_with sys_pcre
%def_enable selinux
%def_disable fam
%def_disable systemtap
%def_enable installed_tests
%def_enable gtk_doc
%def_enable man
%def_enable libmount
%def_disable debug
%def_disable check

Name: glib2
Version: %ver_major.7
Release: alt1

Summary: A library of handy utility functions
License: %lgpl2plus
Group: System/Libraries
Url: ftp://ftp.gnome.org

%if_enabled snapshot
Source: glib-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/glib/%ver_major/glib-%version.tar.xz
%endif

Source1: glib-compat.map
Source2: glib-compat.lds
Source3: gobject-compat.map
Source4: gobject-compat.lds
Source5: gio-compat.map
Source6: gio-compat-2.57.lds

Source10: glib2.sh
Source11: glib2.csh

Patch: glib-2.59.3-alt-compat-version-script.patch
# stop spam about deprecated paths in schemas
Patch1: glib-2.53.5-alt-deprecated_paths-nowarning.patch
Patch2: glib-2.53.7-alt-add-xvt.patch
Patch3: glib-2.38.2-alt-lfs.patch
Patch4: glib-2.50.1-alt-dbus_socket_path.patch

# mike@: fix build with lcc 1.23 (lacks some gcc5 builtins)
Patch10: glib-2.60.1-alt-e2k-lcc.patch

%def_with locales
%if_with locales
Requires: %name-locales = %version
%endif

Provides: lib%name = %version
Obsoletes: lib%name < %version

Provides: %name-core = %version
Obsoletes: %name-core < %version

# use python3
#AutoReqProv: nopython
#%define __python %nil
%add_python3_path %_datadir/glib-2.0/codegen
%allow_python3_import_path %_datadir/glib-2.0/codegen

%if_with sys_pcre
BuildRequires: libpcre-devel >= %pcre_ver
Requires: pcre-config(utf8) pcre-config(unicode-properties)
BuildPreReq: pcre-config(utf8) pcre-config(unicode-properties)
%endif

BuildRequires(pre): meson rpm-build-licenses rpm-build-python3
BuildRequires: gcc-c++ gtk-doc indent
BuildRequires: glibc-kernheaders libdbus-devel libpcre-devel
BuildRequires: libffi-devel zlib-devel libelf-devel
%{?_enable_libmount:BuildRequires: libmount-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel}
%{?_enable_fam:BuildRequires: libgamin-devel}
%{?_enable_systemtap:BuildRequires: libsystemtap-sdt-devel}

# for check  & tests
BuildRequires: /proc dbus-tools-gui desktop-file-utils chrpath

%description
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

%package locales
Summary: Glib internationalization
Group: System/Internationalization
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description locales
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package provides internationalization support for Glib.

%package devel
Summary: Development files and tools for GLib
Group: Development/C
Requires: %name = %version-%release
Requires: rpm-build-gir >= 0.5
Provides: lib%name-devel = %version
Obsoletes: lib%name-devel < %version

%description devel
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package provides header files and development tools for GLIB.

%package devel-static
Summary: Static version of GLib libraries
Group: Development/C
Requires: %name-devel = %version-%release
Provides: lib%name-devel-static = %version
Obsoletes: lib%name-devel-static < %version

%description devel-static
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package provides GLIB static libraries.

%package doc
Summary: Documentation for GLib
Group: Development/Documentation
Provides: %name-devel-doc = %version
Obsoletes: %name-devel-doc < %version
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description doc
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package contains documentation for GLib.

%package -n libgio
Summary: GIO input/output framework
Group: System/Libraries
Provides: gvfs-utils = %version-%release %_bindir/gio
Requires: %name = %version-%release
Requires: gsettings-desktop-schemas
Requires: shared-mime-info >= 0.80

%description -n libgio
GIO is a VFS API, designed to replace GnomeVFS. This GIO implementation is
a part of Glib project; it has support for local filesystems, and
a separate GVFS project contains various backend implementations (CIFS,
FTP, SFTP etc.).

%package -n libgio-devel
Summary: GIO input/output framework
Group: Development/C
Requires: libgio = %version-%release
Requires: %name-devel = %version-%release

%description -n libgio-devel
GIO is a VFS API, designed to replace GnomeVFS. This GIO implementation is
a part of Glib project; it has support for local filesystems, and
a separate GVFS project contains various backend implementations (CIFS,
FTP, SFTP etc.).

This package contains files necessary for development with GIO.

%package -n libgio-doc
Summary: GIO documentation
Group: Development/Documentation
# due to HTML links
Requires: %name-doc = %version-%release
BuildArch: noarch

%description -n libgio-doc
GIO is a VFS API, designed to replace GnomeVFS. This GIO implementation is
a part of Glib project; it has support for local filesystems, and
a separate GVFS project contains various backend implementations (CIFS,
FTP, SFTP etc.).

This package contains documentation for GIO.

%package tests
Summary: Tests for the glib2/libgio packages
Group: Development/Other
Requires: libgio = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed glib2/libgio packages.

%if 0
%package gdb
%description gdb
%endif

%prep
%setup -n glib-%version
%patch -p1 -b .compat_map
%patch1
%patch2 -p1
%patch3 -p1
%patch4

%if_with sys_pcre
rm glib/pcre/*.[ch]
%endif

install -p -m644 %_sourcedir/glib-compat.map glib/compat.map
install -p -m644 %_sourcedir/glib-compat.lds glib/compat.lds
install -p -m644 %_sourcedir/gobject-compat.map gobject/compat.map
install -p -m644 %_sourcedir/gobject-compat.lds gobject/compat.lds
install -p -m644 %_sourcedir/gio-compat.map gio/compat.map
install -p -m644 %_sourcedir/gio-compat-2.57.lds gio/compat.lds

# abicheck always ok
subst '/exit 1/d' check-abis.sh

%ifarch %e2k
subst "/subdir('fuzzing')/d" meson.build
%patch10 -p1
%endif

%build
%meson \
    --default-library=both \
    -Dgio_module_dir='%gio_module_dir' \
    %{?_disable_selinux:-Dselinux=false} \
    %{?_disable_xattr:-Dxattr=false} \
    %{?_disable_libmount:-Dlibmount=false} \
    %{?_enable_gtk_doc:-Dgtk_doc=true} \
    %{?_enable_man:-Dman=true} \
    %{?_without_sys_pcre:-Dinternal_pcre=true} \
    %{?_enable_fam:-Dfam=true} \
    %{?_enable_systemtap:-Dsystemtap=true} \
    %{?_enable_installed_tests:-Dinstalled_tests=true} \
    -Diconv='libc'
%meson_build

%install
%meson_install

# Relocate libgilb-2.0.so.0 to /%_lib.
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libglib-%api_ver.so.0* %buildroot/%_lib
rm %buildroot%_libdir/libglib-%api_ver.so
ln -s ../../%_lib/libglib-%api_ver.so.0 %buildroot%_libdir/libglib-%api_ver.so

install -pD -m755 %_sourcedir/glib2.sh %buildroot%_sysconfdir/profile.d/glib2.sh
install -pD -m755 %_sourcedir/glib2.csh %buildroot%_sysconfdir/profile.d/glib2.csh

chmod +x %buildroot%_bindir/gtester-report

# GIO modules cache
mkdir -p %buildroot%gio_module_dir
touch %buildroot%gio_module_dir/giomodule.cache
# filetrigger that updates GIO modules cache
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%_libdir/gio/modules/
grep -qs '^'\$dir'' && /usr/bin/gio-querymodules \$dir ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gio.filetrigger

# filetrigger that compiles all the GSettings XML schema files under %_datadir/glib-2.0/schemas
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%_datadir/glib-%api_ver/schemas
grep -qs '^'\$dir'' && /usr/bin/glib-compile-schemas --allow-any-name \$dir ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gsettings.filetrigger

%find_lang glib20

%check
# g_mapped_file_new fails on /dev/null in hasher
# GLib:ERROR:mappedfile.c:52:test_device: assertion failed (error == (g-file-error-quark, 17)): Failed to map /dev/null' /dev/null': mmap() failed: No such device (g-file-error-quark, 7)
%meson_test

%files
/%_lib/libglib-%api_ver.so.0*
%_libdir/libgobject-%api_ver.so.0*
%_libdir/libgmodule-%api_ver.so.0*
%_libdir/libgthread-%api_ver.so.0*
%config(noreplace) %_sysconfdir/profile.d/*
%doc AUTHORS NEWS README

%files locales -f glib20.lang

%files devel
%_bindir/glib-genmarshal
%_bindir/glib-gettextize
%_bindir/glib-mkenums
%_bindir/gobject*
%_bindir/gtester*
%dir %_includedir/glib-%api_ver
%_includedir/glib-%api_ver/glib*
%_includedir/glib-%api_ver/gobject*
%_includedir/glib-%api_ver/gmodule*
%dir %_libdir/glib-%api_ver
%dir %_libdir/glib-%api_ver/include
%_libdir/glib-%api_ver/include/*.h
%_libdir/libglib-%api_ver.so
%_libdir/libgmodule-%api_ver.so
%_libdir/libgobject-%api_ver.so
%_libdir/libgthread-%api_ver.so
%_pkgconfigdir/glib-%api_ver.pc
%_pkgconfigdir/gmodule*-%api_ver.pc
%_pkgconfigdir/gobject-%api_ver.pc
%_pkgconfigdir/gthread-%api_ver.pc
%_datadir/aclocal/glib*.m4
%_datadir/aclocal/gsettings.m4
%dir %_datadir/glib-%api_ver
%_datadir/glib-%api_ver/gettext/
%_datadir/gettext/its/gschema.its
%_datadir/gettext/its/gschema.loc
%_datadir/glib-%api_ver/codegen/

%if_enabled man
%_man1dir/glib-genmarshal.*
%_man1dir/glib-gettextize.*
%_man1dir/glib-mkenums.*
%_man1dir/gobject*
%_man1dir/gtester*
%endif

%files devel-static
%_libdir/libglib-%api_ver.a
%_libdir/libgobject-%api_ver.a
%_libdir/libgthread-%api_ver.a
# gmodule and gio use dynamic loading
%exclude %_libdir/libgmodule-%api_ver.a
%exclude %_libdir/libgio-%api_ver.a
%if_enabled fam
%exclude %_libdir/gio/modules/libgiofam.a
%exclude %_libdir/gio/modules/libgiofam.la
%endif

%files doc
%doc %_datadir/gtk-doc/html/glib
%doc %_datadir/gtk-doc/html/gobject

%files -n libgio
%_bindir/gapplication
%_bindir/gio
%_bindir/gio-launch-desktop
%_bindir/gio-querymodules
%_bindir/gsettings
%_bindir/glib-compile-schemas
%_bindir/gresource
%_bindir/glib-compile-resources
%_bindir/gdbus
%_libdir/libgio-%api_ver.so.*
%dir %_libdir/gio
%dir %_libdir/gio/modules
%{?_enable_fam:%_libdir/gio/modules/libgiofam.so}
%_libdir/gio/modules/giomodule.cache
%_rpmlibdir/gio.filetrigger
%_rpmlibdir/gsettings.filetrigger
%_datadir/glib-%api_ver/schemas/

%if_enabled man
%_man1dir/gapplication.1.*
%_man1dir/gsettings.*
%_man1dir/glib-compile-schemas.*
%_man1dir/gresource.*
%_man1dir/glib-compile-resources.1*
%_man1dir/gdbus.*
%_man1dir/gio.1.*
%_man1dir/gio-querymodules.*
%endif

%_datadir/bash-completion/completions/gapplication
%_datadir/bash-completion/completions/gio
%_datadir/bash-completion/completions/gresource
%_datadir/bash-completion/completions/gdbus
%_datadir/bash-completion/completions/gsettings

%files -n libgio-devel
%_bindir/gdbus-codegen
%dir %_includedir/glib-%api_ver
%dir %_includedir/glib-%api_ver/gio
%_includedir/glib-%api_ver/gio/*.h
%dir %_includedir/gio-unix-%api_ver
%dir %_includedir/gio-unix-%api_ver/gio
%_includedir/gio-unix-%api_ver/gio/*.h
%_libdir/libgio-%api_ver.so
%_pkgconfigdir/gio-%api_ver.pc
%_pkgconfigdir/gio-unix-%api_ver.pc
%{?_enable_man:%_man1dir/gdbus-codegen.*}

%files -n libgio-doc
%doc %_datadir/gtk-doc/html/gio

%exclude %_datadir/gdb/auto-load/%_libdir/libglib-%api_ver.so.0.*-gdb.py
%exclude %_datadir/gdb/auto-load/%_libdir/libgobject-%api_ver.so.0.*-gdb.py
%exclude %_datadir/glib-%api_ver/gdb/
%exclude %_datadir/glib-%api_ver/valgrind/

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/glib/
# exclude empty
%exclude %_libexecdir/installed-tests/glib/x-content/unix-software/autorun.sh
%_datadir/installed-tests/glib/
%endif

%changelog
