%define installdir %webserver_webappsdir/%name

Name: glpi
Version: 9.5.13
Release: alt1

Summary: IT and asset management software
License: GPLv2
Group: Networking/Other

URL: http://www.glpi-project.org
Packager: Pavel Zilke <zidex at altlinux dot org>
BuildArch: noarch

Source0: http://www.glpi-project.org/IMG/gz/%name-%version.tar.gz
Source1: apache2.conf
Source2: README.ALT
Source3: UPGRADE.ALT
Patch: patch0.patch

Requires: webserver-common php-engine curl lynx
BuildRequires(pre): rpm-macros-webserver-common

%description
GLPI is the Information Resource-Manager with an additional Administration-
Interface.
You can use it to build up a database with an inventory for your company
(computer, software, printers...).
It has enhanced functions to make the daily life for the administrators easier,
like a job-tracking-system with mail-notification and methods to build a
database with basic information about your network-topology.

%package apache2
Summary: Apache 2.x web-server configuration for %name
Group: Networking/Other
Requires: %name = %version-%release, apache2
%description apache2
Apache 2.x web-server configuration for %name

%package php7
Summary: PHP7 dependencies for %name
Group: Networking/Other
Requires: %name = %version-%release
Requires: php7-curl, php7-fileinfo, php7-gd2, php7-exif, php7-json, php7-mbstring, php7-mysqlnd-mysqli, php7-session, php7-zlib, php7-simplexml, php7-xml, php7-intl
Requires: php7-bz2, php7-imap, php7-ldap, php7-openssl, php7-apcu, php7-xmlrpc, php7-zip, php7-sodium, php7-opcache

%description php7
PHP7 dependencies for %name

%prep
%setup
%patch -p0

%build

%install
# install apache config
install -pD -m0644 %_sourcedir/apache2.conf %buildroot%_sysconfdir/httpd2/conf/sites-available/%name.conf

# install glpi
mkdir -p %buildroot%installdir
cp -rp * %buildroot%installdir/

#install README.ALT and UPGRADE.ALT
install -pD -m0644 %_sourcedir/README.ALT README.ALT
install -pD -m0644 %_sourcedir/UPGRADE.ALT UPGRADE.ALT

# remove .htaccess files - we're use apache config instead
find %buildroot%installdir -name .htaccess -delete

# remove files
#find %buildroot%installdir/files -type f -delete
find $RPM_BUILD_ROOT \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete
find %buildroot%installdir -name *.py -delete
find %buildroot%installdir -name remove.txt -delete
rm -rf %buildroot%installdir/vendor/sabre/dav/bin

%post
echo "If you upgrade from previous version (less than 9.5) then read /usr/share/doc/%name-%version/UPGRADE.ALT"

%post apache2
if [ "$1" = "1" ]; then
  a2ensite %name
  %_initdir/httpd2 condreload
fi

%preun apache2
if [ "$1" = "0" ]; then
  a2dissite %name ||:
fi

%postun apache2
if [ "$1" = "0" ]; then
  %_initdir/httpd2 condreload
fi

%files
%dir %installdir
%dir %attr(2770,root,%webserver_group) %installdir/config
%dir %attr(2770,root,%webserver_group) %installdir/files
%attr(2770,root,%webserver_group) %installdir/files/*
%dir %attr(2770,root,%webserver_group) %installdir/marketplace
%installdir/ajax
%installdir/bin
%installdir/css
%installdir/css_compiled
%installdir/front
%installdir/inc
%installdir/install
%installdir/js
%installdir/lib
%installdir/locales
%installdir/pics
%installdir/plugins
%installdir/public
%installdir/scripts
%installdir/sound
%installdir/vendor
%installdir/*.php
%installdir/COPYING.txt
%doc CHANGELOG.md
%doc CONTRIBUTING.md
%doc README.md
%doc SUPPORT.md
%doc SECURITY.md
%doc apirest.md
%doc README.ALT
%doc UPGRADE.ALT

%files apache2
%config(noreplace) %attr(0644,root,root) %_sysconfdir/httpd2/conf/sites-available/%name.conf

%files php7

%changelog
