Name: glpk
Version: 4.48
Release: alt1

Summary: GNU Linear Programming Kit
License: GPL
Group: Development/Other
Url: http://www.gnu.org/software/glpk/glpk.html

Source0: %name-%version.tar.gz
Requires: lib%name = %version-%release

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Obsoletes: %{name}4
Conflicts: %{name}4

BuildRequires: glibc-devel-static zlib-devel libgmp-devel libltdl7-devel

%package -n lib%name
Summary: GNU Linear Programming Kit shared libraries
Group: System/Libraries
Obsoletes: lib%{name}4
Conflicts: lib%{name}4

%package -n lib%name-devel
Summary: Development headers and files for GLPK
Group: Development/C
Requires: lib%name = %version-%release, pkgconfig
Provides: lib%{name}4-devel = %version-%release
Obsoletes: lib%{name}4-devel < %version-%release
Conflicts: lib%{name}4-devel < %version-%release

%package -n lib%name-devel-doc
Summary: Development documentation for GLPK
Group: Development/Documentation
BuildArch: noarch
Obsoletes: lib%{name}4-devel-doc
Conflicts: lib%{name}4-devel-doc

%description
The glpk (GNU Linear Programming Kit) package is intended for solving
large-scale linear programming (LP), mixed integer programming (MIP),
and other related problems. It is a set of routines written in ANSI C
and organized in the form of a callable library.

glpk supports the GNU MathProg language, which is a subset of the AMPL
language.

The glpk package includes the following main components:

 * Revised simplex method.
 * Primal-dual interior point method.
 * Branch-and-bound method.
 * Translator for GNU MathProg.
 * Application program interface (API).
 * Stand-alone LP/MIP solver.

%description -n lib%name
The glpk (GNU Linear Programming Kit) package is intended for solving
large-scale linear programming (LP), mixed integer programming (MIP),
and other related problems. It is a set of routines written in ANSI C
and organized in the form of a callable library.

This package contains shared library required for run glpk-based software.

%description -n lib%name-devel
The glpk (GNU Linear Programming Kit) package is intended for solving
large-scale linear programming (LP), mixed integer programming (MIP),
and other related problems. It is a set of routines written in ANSI C
and organized in the form of a callable library.

This package contains headers and files for developing applications
which use glpk (GNU Linear Programming Kit).

%description -n lib%name-devel-doc
The glpk (GNU Linear Programming Kit) package is intended for solving
large-scale linear programming (LP), mixed integer programming (MIP),
and other related problems. It is a set of routines written in ANSI C
and organized in the form of a callable library.

This package contains documentation for developing applications
which use glpk (GNU Linear Programming Kit).

%prep
%setup

%build
%add_optflags %optflags_shared
%autoreconf
%configure \
	--includedir=%_includedir/%name \
	--enable-dl \
	--with-gmp \
	--with-zlib
sed -i -e '1a\echo=echo' libtool
%make_build

%install
%makeinstall_std

install -d %buildroot%_docdir/%name
cp -fR doc/* %buildroot%_docdir/%name/
rm -fR examples/.libs
rm -f examples/*.o
cp -fR examples %buildroot%_docdir/%name/

ln -s glpk/glpk.h %buildroot%_includedir

%files 
%_bindir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
#_libdir/pkgconfig/*
%doc AUTHORS ChangeLog COPYING NEWS README THANKS

%files -n lib%name-devel-doc
%_docdir/%name

%changelog
