%def_disable snapshot
%define gimpplugindir %(gimptool-2.0 --gimpplugindir)
%def_enable zart

%define gmic_git_ver v.2.7.1
# https://github.com/c-koi/zart
# no tags
%define zart_ver ca18ba1
# https://github.com/c-koi/gmic-qt
# v.2.6.2
%define gmic_qt_ver v2.7.0-25-gd15d6fc
# https://github.com/dtschump/gmic-community.git
# 1.6.3.2-1245-g44ad9cb
%define gmic_comm_ver 1.6.3.2-1299-g3e81eee

Name: gmic
Version: 2.7.1
Release: alt1

Summary: GREYC's Magic Image Converter
License: CeCILL v.2.0, GPLv3
Group: Graphics
Url: http://gmic.sourceforge.net/

%if_disabled snapshot
Source: http://gmic.eu/files/source/%{name}_%version.tar.gz
%else
# VCS: https://github.com/dtschump/gmic.git
Source: %name-%version.tar
%endif
Source1: zart-%zart_ver.tar
Source2: gmic-qt-%gmic_qt_ver.tar
Source3: gmic-community-%gmic_comm_ver.tar

Requires: lib%name = %version-%release

BuildRequires: dos2unix
BuildRequires: gcc-c++ imake libGraphicsMagick-c++-devel libImageMagick-devel libXext-devel libXrandr-devel
BuildRequires: libavformat-devel libfftw3-devel libgimp-devel libjpeg-devel libopencv-devel libpng-devel
BuildRequires: libswscale-devel libtiff-devel openexr-devel xorg-cf-files zlib-devel libgomp-devel
BuildRequires: libcurl-devel
BuildRequires: bash-completion
# for -zart and -qt
BuildRequires: qt5-base-devel

%description
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%package -n lib%name
Summary: GREYC's Magic Image Converter Library
Group: System/Libraries

%description -n lib%name
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides shared G'MIC library.

%package -n lib%name-devel
Summary: GREYC's Magic Image Converter Library (development package)
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides development files for GREYC's Magic Image Converter Library.

%package zart
Summary: GREYC's image processing language demo
Group: Graphics
Provides: zart = %version-%release
Requires: lib%name = %version-%release

%description zart
ZArt is a computer program whose purpose is to demonstrate the possibilities of
the G'MIC image processing language by offering the choice of several
manipulations on a video stream acquired from a webcam. In other words, ZArt is
a GUI for G'MIC real-time manipulations on the output of a webcam.

%package qt
Summary: Qt-based frontend for G'MIC
Group: Graphics
Requires: %name = %version-%release

%description qt
G'MIC-Qt is a versatile front-end to the image processing framework
G'MIC. It is in fact a plugin for GIMP and Krita, as well as a standalone
application.

%package -n gimp-plugin-gmic
Summary: Image denoising and interpolation plugin for GIMP
Group: Graphics
Requires: gimp

%description -n gimp-plugin-gmic
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%prep
%setup -n gmic-%version -a1 -a2 -a3
dos2unix src/Makefile
# fix libdir
subst 's|\$(USR)/\$(LIB)/|$(USR)/%_lib/|' src/Makefile
# fix libcgmic path
subst 's| \.\.\/\(\.\.\/gmic-community/libcgmic\)| \1|' src/Makefile
%ifnarch %ix86 x86_64
subst 's|-mtune=generic||' src/Makefile
%endif

%build
%add_optflags -D_FILE_OFFSET_BITS=64
pushd src
%make NOSTRIP=1 OPT_CFLAGS="%optflags_default" cli lib libc
popd

pushd %name-qt
%qmake_qt5 CONFIG+=release GMIC_PATH=../src HOST=gimp gmic_qt.pro
%make_build
%qmake_qt5 CONFIG+=release GMIC_PATH=../src HOST=none gmic_qt.pro
%make_build
popd

%if_enabled zart
pushd zart
%qmake_qt5 CONFIG+=release GMIC_PATH=../src zart.pro
%make_build
popd
%endif

%install
cp -f gmic-community/libcgmic/COPYING COPYING-libcgmic

pushd src
%makeinstall_std
popd

pushd %name-qt
%makeinstall_std
popd

%if_enabled zart
pushd zart
%makeinstall_std
popd
%endif

%find_lang --with-man %name

%files -f %name.lang
%_bindir/%name
%_man1dir/%name.1.*
%_datadir/bash-completion/completions/%name
%doc README COPYING

%files qt
%_bindir/%{name}_qt
%doc %name-qt/README*

%files -n lib%name
%_libdir/lib%name.so.*
%_libdir/libc%name.so.*
%doc COPYING COPYING-libcgmic

%files -n lib%name-devel
%_includedir/gmic.h
%_includedir/gmic_libc.h
%_libdir/lib%name.so
%_libdir/libc%name.so

%if_enabled zart
%files zart
%_bindir/zart
%doc zart/README* zart/Licence_CeCILL_V2*
%endif

%files -n gimp-plugin-gmic
%gimpplugindir/plug-ins/*

%changelog
