%define major 0.8

Name: gnome-activity-journal
Version: %major.0
Release: alt1

Summary: Browse and search your Zeitgeist activities

Group: Office
License: GPLv3+
Url: https://launchpad.net/%name

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://launchpad.net/%name/%major/%version/+download/%name-%version.tar

# Simple patch to get rid of rpmlint error about non-executable script
Patch1: %name-non-executable-script-fix.patch

BuildArch: noarch

Requires: zeitgeist >= 0.5.0

PreReq: GConf

# required by zeitgeist extension (internal requirement)
%add_python_req_skip _zeitgeist

# Automatically added by buildreq on Sun Oct 24 2010
BuildRequires: intltool python-module-distutils-extra python-module-paste python-module-peak
BuildRequires: libGConf-devel

%description
GNOME Activity Journal is a tool for easily
browsing and finding files on your computer.
It shows a chronological journal of all file
activity.

%prep
%setup
%patch1 -p1

%build
%python_build

%install
%python_install

%find_lang %name

# FIXME: why do no install?
install -m644 -D build/share/gconf/schemas/%name.schemas %buildroot%_sysconfdir/gconf/schemas/%name.schemas
install -m644 -D build/share/applications/%name.desktop %buildroot/%_desktopdir/%name.desktop

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
   %gconf2_uninstall %name
fi

%files -f %name.lang
%doc README AUTHORS
%_bindir/*
%_datadir/gnome-activity-journal
%_iconsdir/hicolor/*/*/*
%_pixmapsdir/*
%_desktopdir/*
%_man1dir/*
%python_sitelibdir/*
%_datadir/zeitgeist/_zeitgeist/engine/extensions/gnome_activity_journal.*
%_sysconfdir/gconf/schemas/%name.schemas

%changelog
