%def_disable snapshot

%define xdg_name org.gnome.Calendar
%define ver_major 3.32
%define _libexecdir %_prefix/libexec

%def_disable gtk_doc

Name: gnome-calendar
Version: %ver_major.2
Release: alt1

Summary: Calendar application for GNOME
License: %gpl2plus
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Calendar

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

BuildRequires(pre): rpm-build-licenses rpm-build-gnome meson

%define glib_ver 2.44.0
%define gtk_ver 3.22.0
%define ical_ver 1.0.1
%define eds_ver 3.18.0
%define gsds_ver 3.21.2
%define gweather_ver 3.27.2

BuildPreReq: yelp-tools libappstream-glib-devel
BuildPreReq: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildPreReq: libical-devel >= %ical_ver libicu-devel
BuildRequires: libgnome-online-accounts-devel vala-tools
BuildRequires: gobject-introspection-devel
BuildRequires: evolution-data-server-devel >= %eds_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libdazzle-devel libgweather-devel >= %gweather_ver
BuildRequires: libgeoclue2-devel libgeocode-glib-devel
%{?_enable_gtk_doc:BuildRequires: gtk-doc}

%description
Calendar is a calendar application for GNOME.

%package devel-doc
Summary: Development documentation for GNOME Calendar
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides Calendar reference manual.


%prep
%setup

%build
%meson \
      %{?_enable_gtk_doc:-Dgtk_doc=true}
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_desktopdir/%xdg_name.desktop
#%_man1dir/*
%_datadir/glib-2.0/schemas/org.gnome.calendar.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.calendar.enums.xml
%_iconsdir/hicolor/scalable/apps/%xdg_name.svg
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS README.md

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/%name
%endif

%changelog
