%def_disable snapshot

%define ver_major 3.32
%define _libexecdir %_prefix/libexec
%define gst_api_ver 1.0
%define _name org.gnome.Contacts
%def_with cheese

Name: gnome-contacts
Version: %ver_major.1
Release: alt2

Summary: Contacts manager for GNOME
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Contacts

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Patch: %name-3.32.1-up-libhandy.patch

%define glib_ver 2.44
%define gtk_ver 3.24
%define vala_ver 0.17.2
%define tp_glib_ver 0.17.5
%define folks_ver 0.12.1
%define eds_ver 3.13.90
%define cheese_ver 3.5.90
%define geocode_ver 3.15.3

BuildRequires(pre): meson
BuildRequires: yelp-tools docbook-dtds docbook-style-xsl libappstream-glib-devel valadoc
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libtelepathy-glib-devel >= %tp_glib_ver
BuildRequires: libfolks-devel >= %folks_ver libvala-devel >= %vala_ver libgnome-desktop3-devel
BuildRequires: libgnome-online-accounts-devel libgee0.8-devel evolution-data-server-devel >= %eds_ver
BuildRequires: libgeocode-glib-devel >= %geocode_ver libchamplain-gtk3-devel libclutter-gtk3-devel
%{?_with_cheese:BuildRequires: gstreamer%gst_api_ver-devel libcheese-devel >= %cheese_ver}
BuildRequires: gobject-introspection-devel vala-tools libgtk+3-gir-devel
BuildRequires: libhandy-devel

# for build from git
BuildRequires: libfolks-vala

%description
%name is a standalone contacts manager for GNOME desktop.

%prep
%setup
%patch -p1

%build
%meson %{?_without_cheese:-Dcheese=false}
%meson_build

%install
%meson_install

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/gnome-contacts-search-provider
%_datadir/applications/%_name.desktop
%_datadir/glib-2.0/schemas/%_name.gschema.xml
%_datadir/dbus-1/services/%_name.service
%_datadir/dbus-1/services/%_name.SearchProvider.service
%_datadir/gnome-shell/search-providers/%_name.search-provider.ini
%_iconsdir/hicolor/*/*/*
%_man1dir/%name.1.*
%_datadir/metainfo/%_name.appdata.xml
%doc AUTHORS NEWS README*

%changelog
