%define ver_major 2.32
%define api_ver 2.0
%define gnome_distributor "%vendor"
%define gnome_date "%(date "+%%B %%e %%Y"), Moscow"
%def_disable static

Name: gnome-desktop
Version: %ver_major.1
Release: alt4.1

Summary: The gnome desktop programs for the GNOME desktop environment
License: %gpl2plus, %fdl
Group: Graphical desktop/GNOME
Url: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.bz2
Source1: gnome-about.png

Requires: lib%name = %version-%release
Requires: icon-theme-hicolor
# use pnp.ids from hwdatabase package
Requires: hwdatabase >= 0.3.31-alt1

BuildPreReq: rpm-build-licenses rpm-build-gnome

# From configure.in
BuildPreReq: intltool >= 0.35
BuildPreReq: libgtk+2-devel >= 2.22.0
BuildPreReq: glib2-devel >= 2.19.1
BuildPreReq: libgio-devel >= 2.15.4
BuildPreReq: libGConf-devel >= 2.0.0
BuildPreReq: libstartup-notification-devel >= 0.5
BuildPreReq: gnome-doc-utils librarian-devel
BuildPreReq: gtk-doc >= 1.4
BuildPreReq: gnome-common >= 2.8.0
BuildRequires: python-devel python-modules-compiler
BuildRequires: libSM-devel libXrandr-devel
BuildRequires: hwdatabase >= 0.3.31-alt1

%description
GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.  GNOME is similar in purpose and scope
to CDE and KDE, but GNOME is based completely on free software. The
%name package includes the basic programs and libraries that are needed
to install GNOME.

GNOME Desktop provides the core icons and libraries for the gnome
desktop.

%package -n lib%name
Summary: GNOME desktop core libraries
Group: Graphical desktop/GNOME
License: %lgpl2plus

%description -n lib%name
Gnome 2 desktop libraries.

%package -n lib%name-devel
Summary: GNOME desktop develop libraries and includes
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release
License: %lgpl2plus, %fdl

%description -n lib%name-devel
Gnome 2 desktop libraries and header files for creating GNOME panels.

%package -n lib%name-devel-doc
Summary: GNOME desktop development documentation
Group: Development/GNOME and GTK+
Conflicts: lib%name-devel < %version
License: %lgpl2plus, %fdl
BuildArch: noarch

%description -n lib%name-devel-doc
Development documentation for Gnome desktop library.

%if_enabled static
%package -n lib%name-devel-static
Summary: GNOME desktop develop libraries and includes
Group: Development/GNOME and GTK+
Requires: lib%name-devel = %version-%release
License: %lgpl2plus

%description -n lib%name-devel-static
Gnome 2 desktop static libraries for creating GNOME panels.
%endif

%prep
%setup -q

%build
%configure \
    %{subst_enable static} \
    --disable-rebuilds \
    --disable-scrollkeeper \
    --with-gnome-distributor=%gnome_distributor \
    --with-pnp-ids-path=%_datadir/misc

%make_build

%install
%make_install DESTDIR=%buildroot install

# already shipped in gnome-desktop3
rm -rf %buildroot%_datadir/omf
rm -rf %buildroot%_datadir/gnome/help

%find_lang --with-gnome --output=%name.lang %name-%api_ver

%files
%_bindir/*
%_desktopdir/*
%_datadir/gnome-about
%_pixmapsdir/*
%_man1dir/*
%doc AUTHORS NEWS README

%files -n lib%name -f %name.lang
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
