%def_disable snapshot

%define xdg_name org.gnome.Documents
%define ver_major 3.32
%define api_ver 1.0
%define _libexecdir %_prefix/libexec

Name: gnome-documents
Version: %ver_major.0
Release: alt1

Summary: A document manager application for GNOME
Group: Office
License: GPLv2+
Url: https://wiki.gnome.org/Apps/Documents

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define lok_ver 5.2-alt2
%define glib_ver 2.40.0
%define gtk_ver 3.20.0
%define evince_ver 3.13.3
%define tracker_ver 1.99
%define goa_ver 3.2.0
%define gdata_ver 0.17.2
%define soup_ver 2.41.3
%define gi_ver 1.31.6

Requires: %name-data = %version-%release
Requires: gnome-online-miners
Requires: libreofficekit >= %lok_ver

# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(cairo)
Requires: typelib(EvinceDocument)
Requires: typelib(EvinceView)
Requires: typelib(Gd)
Requires: typelib(GData)
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(GdPrivate)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GnomeDesktop)
Requires: typelib(Goa)
Requires: typelib(GObject)
Requires: typelib(Gtk)
Requires: typelib(LOKDocView)
Requires: typelib(Pango)
Requires: typelib(Tracker) = 2.0
Requires: typelib(TrackerControl)
Requires: typelib(WebKit2)
Requires: typelib(Zpj)

%define pkglibdir %_libdir/%name
%define pkgdatadir %_datadir/%name
%set_typelibdir %pkglibdir
%set_girdir %pkgdatadir

BuildRequires(pre): meson rpm-build-gir
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils docbook-style-xsl
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libgnome-desktop3-devel libgdata-devel >= %gdata_ver
BuildRequires: liboauth-devel libgnome-online-accounts-devel >= %goa_ver
BuildRequires: pkgconfig(tracker-control-2.0) pkgconfig(tracker-sparql-2.0)
BuildRequires: libevince-devel >= %evince_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: libwebkit2gtk-devel
BuildRequires: libzapojit-devel
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libgtk+3-gir-devel libgjs-devel libevince-gir-devel libgnome-desktop3-gir-devel
BuildRequires: libgdata-gir-devel libgnome-online-accounts-gir-devel libtracker-gir-devel >= %tracker_ver
BuildRequires: libzapojit-gir-devel
BuildRequires: librsvg

%description
gnome-documents is a document manager application for GNOME,
aiming to be a simple and elegant replacement for using Files to show
the Documents directory.

%package data
Summary: Arch independent files for %name
Group: Office
BuildArch: noarch
Requires: %name-gir = %version-%release

%description data
This package provides noarch data needed for %name to work.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package gir
Summary: GObject introspection data for %name
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the %name library.

%package gir-devel
Summary: GObject introspection devel data for %name
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release
Requires: %name-gir = %version-%release

%description gir-devel
GObject introspection devel data for the %name library.


%prep
%setup

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files
%_bindir/%name
%dir %pkglibdir
%pkglibdir/*.so
%_man1dir/%name.1.*
# contains arch dependent scripts
%pkgdatadir/
%exclude %pkgdatadir/gir-1.0
%doc README* AUTHORS NEWS TODO

%files gir
%dir %pkglibdir/girepository-1.0
%pkglibdir/girepository-1.0/Gd-%api_ver.typelib
%pkglibdir/girepository-1.0/GdPrivate-1.0.typelib

%files data -f %name.lang
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/%xdg_name.enums.xml
%_datadir/glib-2.0/schemas/org.gnome.documents.gschema.xml
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/symbolic/apps/*.svg
%_iconsdir/hicolor/scalable/apps/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml


%changelog
