%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name 2048
%define __name gnome-%_name
%define ver_major 3.32
%define xdg_name org.gnome.TwentyFortyEight

Name: gnome-games-%_name
Version: %ver_major.0
Release: alt1

Summary: A 2048 clone for GNOME
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/2048

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %__name = %version-%release

%define gtk_ver 3.22.3
%define clutter_gtk_ver 1.6
%define gee_ver 0.14
%define libgames_ver 1.2.0
%define vala_ver 0.24

BuildRequires(pre): meson
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: vala-tools >= %vala_ver
BuildRequires: libgtk+3-devel >= %gtk_ver libclutter-gtk3-devel >= %clutter_gtk_ver
BuildRequires: libgee0.8-devel >= %gee_ver libgnome-games-support-devel >= %libgames_ver

%description
Move the tiles until you obtain the 2048 tile.

%prep
%setup -n %__name-%version

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%{xdg_name}*.svg
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
