%define _unpackaged_files_terminate_build 1

%define _name atomix
%define xdg_name org.gnome.Atomix
%define ver_major 3.32
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt1

Summary: Build molecules out of single atoms
Group: Games/Boards
License: GPLv2+
Url: https://wiki.gnome.org/Apps/Atomix

Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz

Provides:  %_name = %version-%release

%define glib_ver 2.36.0
%define gtk_ver 3.22.0

BuildRequires(pre): meson
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libxml2-devel libgnome-games-support-devel

%description
Atomix is a puzzle game in which you have to build full molecules, from simple
inorganic ones in the first levels to extremely complex organic ones in the
last levels, out of isolated atoms, which are laying around among walls and
other obstacles on the playfield.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %_name

%files -f %_name.lang
%_bindir/%_name
%_desktopdir/%_name.desktop
%_datadir/%_name/
%_iconsdir/hicolor/*/*/%{_name}*.*
%_datadir/metainfo/%_name.appdata.xml
%doc AUTHORS NEWS README


%changelog
