%define ver_major 3.32
%define api_ver 3.0
%def_enable introspection

Name: gnome-menus
Version: %ver_major.0
Release: alt1

Summary: GNOME desktop menu
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Patch1: %name-3.31.4-alt-add-config-dir.patch

BuildRequires(pre): rpm-build-gnome rpm-build-xdg

BuildRequires: gnome-common libgio-devel >= 2.29.15
%{?_enable_introspection:BuildRequires: gobject-introspection-devel}

%description
This package should not be in a repository. If you see this, please file
a bug to http://bugzilla.altlinux.org against gnome-menus component.

%package default
Summary: GNOME Menus common data
License: GPLv2+
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: gnome-menus = %version-%release
Obsoletes: gnome-menus < 2.26.2-alt2

%description default
The package contains an implementation of the draft "Desktop Menu
Specification" from http://www.freedesktop.org/Standards/menu-spec/

%package -n lib%name
Summary: Desktop Menu Library for GNOME
License: LGPLv2+
Group: System/Libraries
Obsoletes: gnome-menu-editor
Obsoletes: gnome-menus-common
Provides: gnome-menus-common = %version-%release

%description -n lib%name
This package provides Desktop Menu Library for GNOME.

%package -n lib%name-devel
Summary: Development files for GNOME Desktop Menu Library
License: LGPLv2+
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides files required to develop programs that use
Desktop Menu Library.

%package -n lib%name-devel-examples
Summary: Development utilities and examples for GNOME Desktop Menu Library
License: LGPLv2+
Group: Development/Python
BuildArch: noarch
Requires: lib%name = %version-%release

%description -n lib%name-devel-examples
This package provides some examples that use Desktop Menu Library.

%package -n lib%name-gir
Summary: GObject introspection data for the GNOME Desktop Menu Library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GNOME Desktop Menu Library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GNOME Desktop Menu Library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Desktop Menu Library

%add_findreq_skiplist %_xdgmenusdir/*


%prep
%setup
%patch1 -b .config_dir

%build
%add_optflags -D_FILE_OFFSET_BITS=64
%autoreconf
%configure \
    --disable-static \
    %{subst_enable introspection}
%make_build

%install
%makeinstall_std
%find_lang %name

%files default
%_datadir/desktop-directories/*
%exclude %_xdgmenusdir/gnome-applications.menu

%files -n lib%name -f %name.lang
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif


%changelog
