%define ver_major 2.0
%define xdg_name org.gnome.Recipes

Name: gnome-recipes
Version: %ver_major.2
Release: alt2

Summary: GNOME likes to cook
License: GPLv3+
Group: Office
Url: https://wiki.gnome.org/Apps/Recipes

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Obsoletes: recipes < 0.14
Provides: recipes = %EVR

Requires: %name-data = %EVR

%define gtk_ver 3.20

BuildRequires: meson git-core libappstream-glib-devel rpm-build-xdg yelp-tools
BuildRequires: libgtk+3-devel >= %gtk_ver libjson-glib-devel
BuildRequires: libgspell-devel libgnome-autoar-devel libsoup-devel
BuildRequires: libcanberra-gtk3-devel
BuildRequires: libgnome-online-accounts-devel librest-devel
BuildRequires: vala-tools gobject-introspection-devel

%description
Recipes is an easy to use app that will help you to discover what to cook today,
tomorrow, the rest of the week and for your special occasions.

%package data
Summary: Recipes data files
Group: Office
BuildArch: noarch
Obsoletes: recipes-data < 0.14
Provides: recipes-data = %EVR

%description data
Recipes is an easy to use app that will help you to discover what to cook today,
tomorrow, the rest of the week and for your special occasions.

This package contains common noarch files needed for Recipes.


%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name
%find_lang --with-gnome --output=%name.lang %name %name-data %xdg_name

%check
%meson_test

%files
%_bindir/%name
%doc README.md

%files data -f %name.lang
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/symbolic/apps/*.svg
%_xdgmimedir/packages/org.gnome.Recipes-mime.xml
%_datadir/appdata/%xdg_name.appdata.xml


%changelog
