%define _unpackaged_files_terminate_build 1
%define ver_major 3.32
%define xdg_name org.gnome.SoundRecorder
%define gst_api_ver 1.0

Name: gnome-sound-recorder
Version: %ver_major.1
Release: alt1

Summary: Sound Recorder for GNOME
Group: Sound
License: GPLv2+
Url: https://wiki.gnome.org/Design/Apps/SoundRecorder

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Obsoletes: gnome-media-common
Obsoletes: gnome-media-grecord
Provides:  gnome-media-grecord = %version-%release

%define glib_ver 2.31.10
%define gtk_ver 3.10.8
%define gjs_ver 1.48

Requires: libgjs >= %gjs_ver
Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver
Requires: gstreamer%gst_api_ver-utils
# find ./ -name "*.js" |/usr/lib/rpm/gir-js.req |sort|uniq|sed -e 's/^/Requires: /'
Requires: typelib(Gdk)
Requires: typelib(GdkPixbuf)
Requires: typelib(Gio)
Requires: typelib(GLib)
Requires: typelib(GObject)
Requires: typelib(Gst)
Requires: typelib(GstAudio)
Requires: typelib(GstPbutils)
Requires: typelib(Gtk)
Requires: typelib(Pango)
# explicitly required to avoid installation old version
Requires: libgst-plugins%gst_api_ver-gir

BuildRequires(pre): meson
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libgjs-devel libgtk+3-gir-devel yelp-tools
BuildRequires: gst-plugins%gst_api_ver-devel
BuildRequires: gstreamer%gst_api_ver-utils gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver gst-plugins-bad%gst_api_ver

%description
The GNOME application for record and play sound files.

%prep
%setup

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome --output=%name.lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/metainfo/%xdg_name.appdata.xml
%doc NEWS README*


%changelog
