%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 3.32
%define old_name gnome-tweak-tool
%define xdg_name org.gnome.tweaks

Name: gnome-tweaks
Version: %ver_major.0
Release: alt1

Summary: A tool to customize advanced GNOME 3 options
Group: Graphical desktop/GNOME
License: GPLv3
Url: https://wiki.gnome.org/Apps/Tweaks

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif
Patch: %name-3.27.4-alt-desktop.patch

BuildArch: noarch
Requires: gnome-shell >= %ver_major nautilus
Requires: gsettings-desktop-schemas-devel >= 3.27.90

Provides: %old_name = %version-%release
Obsoletes: %old_name < 3.27.4

BuildRequires(pre): meson rpm-build-gir rpm-build-python3
BuildRequires: gsettings-desktop-schemas-devel >= 3.27.2
BuildRequires: python3-module-pygobject3-devel >= 3.10.0

%description
GNOME Tweaks is an application for changing the advanced settings
of GNOME 3.

Features:
* Install and switch gnome-shell themes
* Switch GTK+ themes
* Switch icon themes
* Change
  - The user-interface and title bar fonts
  - Icons in menus and buttons
  - Behavior on laptop lid close
  - Shell font size
  - File manager desktop icons
  - Title bar click action
  - Shell clock to show date
  - Font hinting
  - Font anti-aliasing

%prep
%setup
%patch -b .desktop

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%old_name-lid-inhibitor
%python3_sitelibdir_noarch/gtweak/
%_desktopdir/%xdg_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/*/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS README*

%changelog
