%define _name gnubiff

%def_with password

Name: %_name
Version: 2.2.15
Release: alt1.2

Summary: gnubiff is a mail notifier that displays headers when new mail has arrived.
License: %gpl3plus w/exception for OpenSSL
Group: Networking/Mail
Url: http://gnubiff.sourceforge.net

Source: http://downloads.sourceforge.net/%_name/%_name-%version.tar.gz
Source2: %name.desktop

BuildPreReq: rpm-build-licenses

# From configure.ac
BuildPreReq: libgamin-devel >= 0.1.0
BuildPreReq: libgtk+3-devel
BuildPreReq: glib2-devel >= 2.4
BuildPreReq: libglade2-devel >= 2.3
BuildPreReq: libpopt-devel

BuildRequires: gcc-c++ libxml2-devel perl-XML-Parser intltool
BuildPreReq: libssl-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
gnubiff is a mail notification program that checks for mail and displays
headers when new mail has arrived. This package contains Gtk+ version that
does not need a GNOME panel to work.

gnubiff features include:

    * Multiple mailbox support
    * pop3, apop, imap4, mh, qmail and mailfile support
    * SSL & certificates support
    * GNOME support with complete integration to panel
    * GTK stand-alone support
    * Automatic detection of mailbox format
    * Mail header & content display
    * IDLE state support for imap4
    * FAM support for mh/qmail/mailfile
    * PNG animation support
    * Highly configurable
    * Spam filtering
    * HIG 2.0 compliance
    * Small memory usage

%prep
%setup -n %_name-%version

%build
%autoreconf
%configure \
    %{subst_with password} \
    %{?_with_password:--with-password-string="andthentherewere3"} \
    --enable-expert \
    --disable-gnome \
		--disable-rpath

%make_build

%install
%makeinstall_std
install -pD -m644 %SOURCE2 %buildroot%_desktopdir/%name.desktop

%find_lang %_name

%files -f %_name.lang
%_bindir/%_name
%dir %_datadir/%_name
%_datadir/%_name/*
%_pixmapsdir/*
%_desktopdir/*.desktop
%_infodir/*.info*
%_man1dir/*
%doc README ChangeLog COPYING THANKS TODO NEWS AUTHORS

%changelog
