Name: gpm
Version: 1.20.1
Release: alt18.1

Summary: A mouse server for the Linux console
License: GPLv2+
Group: System/Servers
Url: http://www.nico.schottelius.org/software/gpm/

# ftp://arcana.linux.it/pub/gpm/gpm-%version.tar.bz2
Source: gpm-%version.tar
Source1: gpm.init
Source2: gpm.service

Patch1: gpm-1.20.1-alt-texinfo.patch
Patch2: gpm-1.20.1-owl-gpm-root.patch
Patch3: gpm-1.20.1-owl-liblow.patch
Patch4: gpm-1.20.1-owl-warnings.patch
Patch5: gpm-1.20.1-alt-daemonize.patch
Patch6: gpm-1.20.1-alt-get_console.patch
Patch7: gpm-1.20.1-alt-syslog.patch
Patch8: gpm-1.20.1-alt-nodebug.patch
Patch9: gpm-1.20.1-alt-log.patch
Patch10: gpm-1.20.1-alt-progname.patch
Patch11: gpm-1.20.1-alt-pam_console_apply.patch
Patch12: gpm-1.20.1-alt-rh-shlib.patch
Patch13: gpm-1.20.1-deb-alt-xterm_mouse_support.patch
Patch14: gpm-1.20.1-mdk-alt-consolename.patch
Patch15: gpm-1.20.1-alt-netmouse.patch
Patch16: gpm-1.20.1-deb-stack-fix.patch
Patch17: gpm-1.20.1-alt-gpm_open-shutup.patch
Patch18: gpm-1.20.1-alt-libm.patch
Patch19: gpm-1.20.1-alt-AC_GNU_SOURCE.patch
Patch20: gpm-1.20.1-alt-mice.patch
Patch21: 0001-Un-nest-wacom-helpers-in-src-mice.c-for-Clang-compat.patch
Patch22: 0002-Un-nest-summa-helpers-in-src-mice.c-for-Clang-compat.patch
Patch23: gpm-1.20.1-alt-sigemptyset.patch

Requires: lib%name = %version-%release

# Automatically added by buildreq on Sat Mar 10 2007
BuildRequires: libncurses-devel
BuildRequires: makeinfo

%package -n lib%name
Summary: Shared library for running mouse driven programs
Group: System/Libraries
Provides: %name-lib = %version
Obsoletes: %name-lib

%package -n lib%name-devel
Summary: Include files for developing mouse driven programs
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel

%package -n lib%name-devel-static
Summary: Static library for developing static mouse driven programs
Group: Development/C
Requires: lib%name-devel = %version-%release
Requires: libtinfo-devel-static

%package root
Summary: A mouse server add-on which draws pop-up menus on the console
Group: System/Servers
Requires: %name = %version-%release

%description
gpm provides mouse support to text-based Linux applications
as well as console cut-and-paste operations using the mouse.

%description -n lib%name
This package contains the shared library needed for running of
mouse driven programs for the console.

%description -n lib%name-devel
This package contains the libraries and header files needed
for the development of mouse driven programs for the console.

%description -n lib%name-devel-static
This package contains the static library needed for the development
of statically linked mouse driven programs for the console.

%description root
The gpm-root program allows pop-up menus to appear on a text console
at the click of a mouse button.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p2

find -type f -name \*.orig -delete

%build
find -type f -name \*.y |while read f; do
	rm -fv "${f%%.y}.c"
done

export ac_cv_path_emacs=no
%autoreconf
%configure
# SMP-incompatible build.
%make

%install
mkdir -p %buildroot/dev

%makeinstall
mv %buildroot%_bindir/gpm-root %buildroot%_sbindir/
chmod 644 %buildroot%_libdir/*.so*

install -p -m644 doc/gpm-root.1 %buildroot%_man1dir/
install -p -m644 conf/gpm-root.conf %buildroot%_sysconfdir/

install -pD -m755 %_sourcedir/gpm.init %buildroot%_initdir/gpm
install -pD -m644 %_sourcedir/gpm.service %buildroot%_unitdir/gpm.service

mksock %buildroot/dev/gpmctl

bzip2 -9 Changelog ||:

%post
%post_service gpm

%preun
%preun_service gpm

%triggerpostun -- gpm < 0:1.20.1-alt2
/sbin/chkconfig --add gpm ||:

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files -n lib%name-devel-static
%_libdir/*.a

%files
%_initdir/gpm
%_unitdir/gpm.service
%ghost %attr(600,root,root) %verify(not user) /dev/gpmctl
%_bindir/*
%_sbindir/gpm
%_man1dir/mev.1*
%_man1dir/mouse-test.1*
%_man7dir/*
%_man8dir/*
%_infodir/*.info*
%doc Change* doc/FAQ README TODO BUGS doc/README.* doc/Announce

%files root
%config(noreplace) %_sysconfdir/gpm-root.conf
%_sbindir/gpm-root
%_man1dir/gpm-root.1*

%changelog
