%def_disable snapshot
%def_enable check

Name: gpodder
Version: 3.10.11
Release: alt1

Summary: podcast receiver/catcher in PyGTK
License: GPLv3
Group: Sound
Url: http://gpodder.org

%if_disabled snapshot
Source: https://github.com/gpodder/gpodder/archive/%version/%name-%version.tar.gz
%else
# VCS: https://github.com/gpodder/gpodder.git
Source: %name-%version.tar
%endif

BuildArch: noarch

AutoReqProv: nopython
%define __python %nil
%add_python3_path %_datadir/%name

# M$ and ubuntu specific
%add_python3_req_skip comtypes pywintypes win32gui appindicator
%filter_from_requires /win32ctypes/d
%add_typelib_req_skiplist typelib(Unity)
# Optional dependencies
# https://github.com/SoCo/SoCo
%add_python3_req_skip soco
# https://github.com/freevo/kaa-metadata
# last commit in 2015
%add_python3_req_skip kaa.metadata

Requires: %_bindir/ffmpeg xdg-utils
Requires: python3-module-eyeD3

BuildRequires(pre): rpm-build-python3 rpm-build-gir
BuildRequires: python3-devel python3-module-mygpoclient
BuildRequires: python3-module-feedparser help2man intltool desktop-file-utils
%if_enabled check
BuildRequires: python3-module-podcastparser python3-modules-sqlite3
BuildRequires: python3-module-minimock python3-module-coverage
%endif

%description
gPodder enables you to subscribe to RSS feeds and download
podcast episodes from these feeds. gPodder can operate in
GUI mode and in CLI mode. Downloaded podcasts can either
be synchronized to portable MP3 players (including iPods)
or played back on the user's desktop.

%prep
%setup

%build
%make

%install
%makeinstall_std

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Tuner \
	%buildroot%_desktopdir/gpodder.desktop

%check
PYTHON=python3 %make unittest

%files -f %name.lang
%_bindir/*
%python3_sitelibdir/*
%_desktopdir/%name.desktop
%_desktopdir/%name-url-handler.desktop
%_datadir/dbus-1/services/org.gpodder.service
%_datadir/%name
%_iconsdir/hicolor/*/apps/%name.svg
%_iconsdir/hicolor/*/apps/%name.png
%_man1dir/*
%_datadir/metainfo/*.appdata.xml


%changelog
