Name: gprolog
Version: 1.4.4
Release: alt2
Summary: GNU Prolog is a free Prolog compiler

Group: Development/Other
License: GPLv2
Packager: Ilya Mashkin <oddity@altlinux.ru>
Url: http://www.gprolog.org
Source: http://www.gprolog.org/gprolog-%version.tar.gz
Patch1: gprolog-1.4.0-test.patch
Patch2: gprolog-1.3.0-linedit.patch

Obsoletes: gprolog-examples < 1.4.0
Provides: gprolog-examples = %version-%release

#ExclusiveArch: x86_64 %ix86 ppc alpha

%description
GNU Prolog is a native Prolog compiler with constraint solving over
finite domains (FD) developed by Daniel Diaz
(http://loco.inria.fr/~diaz).

GNU Prolog is a very efficient native compiler producing (small)
stand-alone executables. GNU-Prolog also offers a classical
top-level+debugger.

GNU Prolog conforms to the ISO standard for Prolog but also includes a
lot of extensions (global variables, DCG, sockets, OS interface,...).

GNU Prolog also includes a powerful constraint solver over finite
domains with many predefined constraints+heuristics.

#package examples
#Summary: Examples for GNU Prolog
#Group: Development/Other
#Requires: %name = %version-%release

#description examples
#Examples for GNU Prolog.

%package docs
Summary: Documentation for GNU Prolog
Group: Documentation
Requires: %name = %version-%release

%description docs
Documentation for GNU Prolog.

%prep
%setup
#patch1 -p1
# %patch2 -p1

%build
cd src

# gprolog only acccept -O0 and don't like -fomit-frame-pointer

CFLG="$(echo $RPM_OPT_FLAGS | sed -s "s/\-O2/-O1/g" \
     		    | sed -e "s/\-fomit-frame-pointer//")"

# Based on a gentoo ebuild (??)
CFLG="$CFLG -funsigned-char"

# sed -i -e "s:TXT_FILES      = @TXT_FILES@:TXT_FILES=:" Makefile.in
./configure \
       --with-install-dir=$RPM_BUILD_ROOT%_libdir/gprolog-%version \
       --without-links-dir --without-examples-dir \
       --with-doc-dir=dist-doc \
      --with-c-flags="$CFLG"

# _smp_flags seems to make trouble
make

%check
cd src
#
export PATH=$RPM_BUILD_ROOT%_bindir:$PATH
#
make check

%install
cd src
(
    make install
    mkdir $RPM_BUILD_ROOT%_bindir
    cd $RPM_BUILD_ROOT%_libdir/gprolog-%version/bin
    for i in *; do
 	ln -s ../%_lib/gprolog-%version/bin/$i $RPM_BUILD_ROOT%_bindir/$i
    done
)
rm -f dist-doc/*.{chm,dvi,ps}
rm -f dist-doc/compil-scheme.pdf
rm -f dist-doc/debug-box.pdf

for file in ChangeLog COPYING NEWS VERSION
do
    rm -f $RPM_BUILD_ROOT%_libdir/gprolog-%version/$file
done

#cd ../ExamplesPl

rm -rf BINPROLOG CIAO SICSTUS
rm -rf SWI WAMCC XSB YAP

%files
%doc README COPYING ChangeLog NEWS PROBLEMS VERSION
%_bindir/*
%_libdir/gprolog-%version

#files examples
#doc ExamplesC ExamplesFD ExamplesPl

%files docs
%doc src/dist-doc/*

%changelog
