%define _unpackaged_files_terminate_build 1

Name: gpui
Version: 0.2.14
Release: alt1

Summary: Group policy editor
License: GPLv2+
Group: Other
Url: https://github.com/august-alt/gpui

BuildRequires: cmake
BuildRequires: rpm-macros-cmake
BuildRequires: cmake-modules
BuildRequires: gcc-c++
BuildRequires: qt5-base-devel
BuildRequires: qt5-declarative-devel
BuildRequires: qt5-tools-devel
BuildRequires: libsmbclient-devel libsmbclient

BuildRequires: qt5-base-common
BuildRequires: doxygen
BuildRequires: libxerces-c-devel
BuildRequires: xsd
BuildRequires: boost-devel-headers

BuildRequires: desktop-file-utils ImageMagick-tools

Requires: admx-basealt

Source0: %name-%version.tar

%description
Group policy editor

%prep
%setup -q

%build
%cmake
%cmake_build

%install
%cmakeinstall_std

cd %_cmake__builddir
desktop-file-install --dir=%buildroot%_desktopdir \
                     --set-key Exec --set-value %_bindir/gpui-main \
                     ../setup/gpui.desktop

for size in 48 64 128 256 512; do
    mkdir -p %buildroot%_datadir/icons/hicolor/''${size}x''${size}/apps/
    convert ../setup/logo_1024_1024.png -resize ''${size}x''${size} \
    %buildroot%_datadir/icons/hicolor/''${size}x''${size}/apps/gpui.png
done

install -v -p -m 644 -D ../setup/man/en/gpui.1 %buildroot%_man1dir/gpui.1
install -v -p -m 644 -D ../setup/man/ru/gpui.1 %buildroot%_mandir/ru/man1/gpui.1

%files
%doc README.md
%doc INSTALL.md
%_bindir/gpui-main

%_libdir/libgpui-gui.so
%_libdir/libgpui-io.so
%_libdir/libgpui-model.so

%_libdir/gpui/plugins/libadml-plugin.so
%_libdir/gpui/plugins/libadmx-plugin.so
%_libdir/gpui/plugins/libcmtl-plugin.so
%_libdir/gpui/plugins/libcmtx-plugin.so
%_libdir/gpui/plugins/libinifile-plugin.so
%_libdir/gpui/plugins/libreg-plugin.so
%_libdir/gpui/plugins/libspol-plugin.so
%_libdir/gpui/plugins/libpol-plugin.so

%_libdir/gpui/plugins/libdrives-plugin.so
%_libdir/gpui/plugins/libfiles-plugin.so
%_libdir/gpui/plugins/libfolders-plugin.so
%_libdir/gpui/plugins/libini-plugin.so
%_libdir/gpui/plugins/libshares-plugin.so
%_libdir/gpui/plugins/libshortcuts-plugin.so
%_libdir/gpui/plugins/libvariables-plugin.so

%_libdir/gpui/plugins/libsmb-storage-plugin.so

%_datadir/icons/hicolor/48x48/apps/gpui.png
%_datadir/icons/hicolor/64x64/apps/gpui.png
%_datadir/icons/hicolor/128x128/apps/gpui.png
%_datadir/icons/hicolor/256x256/apps/gpui.png
%_datadir/icons/hicolor/512x512/apps/gpui.png

%_desktopdir/gpui.desktop

%_man1dir/gpui.*
%_mandir/ru/man1/gpui.*

%changelog
