%define _unpackaged_files_terminate_build 1
#add_python3_self_prov_path %buildroot%python3_sitelibdir/gpoa

#%add_python3_req_skip backend
#%add_python3_req_skip frontend.frontend_manager
#%add_python3_req_skip gpt.envvars
#%add_python3_req_skip gpt.folders
#%add_python3_req_skip gpt.gpt
#%add_python3_req_skip gpt.printers
#%add_python3_req_skip gpt.shortcuts
#%add_python3_req_skip messages
#%add_python3_req_skip storage
#%add_python3_req_skip storage.fs_file_cache
#%add_python3_req_skip util
#%add_python3_req_skip util.arguments
#%add_python3_req_skip util.config
#%add_python3_req_skip util.dbus
#%add_python3_req_skip util.exceptions
#%add_python3_req_skip util.kerberos
#%add_python3_req_skip util.logging
#%add_python3_req_skip util.paths
#%add_python3_req_skip util.preg
#%add_python3_req_skip util.roles
#%add_python3_req_skip util.rpm
#%add_python3_req_skip util.sid
#%add_python3_req_skip util.signals
#%add_python3_req_skip util.system
#%add_python3_req_skip util.users
#%add_python3_req_skip util.util
#%add_python3_req_skip util.windows
#%add_python3_req_skip util.xml

Name: gpupdate
Version: 0.9.12.2
Release: alt1.p9.1

Summary: GPT applier
License: GPLv3+
Group: Other
Url: https://github.com/altlinux/gpupdate
BuildArch: noarch

Requires: control

BuildRequires: rpm-build-python3
BuildRequires: gettext-tools
Requires: python3-module-rpm
Requires: python3-module-dbus
Requires: oddjob-%name >= 0.2.0
Requires: libnss-role >= 0.5.0
Requires: local-policy >= 0.4.9
Requires: pam-config >= 1.9.0
Requires: autofs
# This is needed by shortcuts_applier
Requires: desktop-file-utils
# This is needed for smb file cache support
Requires: python3-module-smbc >= 1.0.23-alt3

Source0: %name-%version.tar

%description
gpupdate is the facility to apply various GPO/GPT settings retrieved
from Active Directory domain in UNIX environment.

%prep
%setup -q

%install
mkdir -p \
	%buildroot%python3_sitelibdir/
cp -r gpoa \
	%buildroot%python3_sitelibdir/

# Generate translations
msgfmt \
	-o %buildroot%python3_sitelibdir/gpoa/locale/ru_RU/LC_MESSAGES/gpoa.mo \
	%buildroot%python3_sitelibdir/gpoa/locale/ru_RU/LC_MESSAGES/gpoa.po

mkdir -p \
	%buildroot%_bindir/ \
	%buildroot%_sbindir/ \
	%buildroot%_cachedir/%name/ \
	%buildroot%_cachedir/%{name}_file_cache/ \
	%buildroot%_cachedir/%name/creds

ln -s %python3_sitelibdir/gpoa/gpoa \
	%buildroot%_sbindir/gpoa
ln -s %python3_sitelibdir/gpoa/gpupdate \
	%buildroot%_bindir/gpupdate

ln -s %python3_sitelibdir/gpoa/gpupdate-setup \
	%buildroot%_sbindir/gpupdate-setup

mkdir -p \
	%buildroot%_prefix/libexec/%name

ln -s %python3_sitelibdir/gpoa/pkcon_runner \
	%buildroot%_prefix/libexec/%name/pkcon_runner
ln -s %python3_sitelibdir/gpoa/scripts_runner \
	%buildroot%_prefix/libexec/%name/scripts_runner

mkdir -p %buildroot%_datadir/%name
mv %buildroot%python3_sitelibdir/gpoa/templates \
	%buildroot%_datadir/%name/

mkdir -p %buildroot%_sysconfdir/%name
touch %buildroot%_sysconfdir/%name/environment

install -Dm0644 dist/%name.service %buildroot%_unitdir/%name.service
install -Dm0644 dist/%name.timer %buildroot%_unitdir/%name.timer
install -Dm0644 dist/%name-scripts-run.service %buildroot%_unitdir/%name-scripts-run.service
install -Dm0644 dist/%name-user.service %buildroot/usr/lib/systemd/user/%name-user.service
install -Dm0644 dist/%name-scripts-run-user.service %buildroot/usr/lib/systemd/user/%name-scripts-run-user.service
install -Dm0644 dist/%name-user.timer %buildroot/usr/lib/systemd/user/%name-user.timer
install -Dm0644 dist/system-policy-%name %buildroot%_sysconfdir/pam.d/system-policy-%name
install -Dm0644 dist/%name-remote-policy %buildroot%_sysconfdir/pam.d/%name-remote-policy
install -Dm0644 dist/%name.ini %buildroot%_sysconfdir/%name/%name.ini
install -Dm0644 doc/gpoa.1 %buildroot/%_man1dir/gpoa.1
install -Dm0644 doc/gpupdate.1 %buildroot/%_man1dir/gpupdate.1

for i in gpupdate-localusers \
	 gpupdate-group-users \
	 gpupdate-system-uids
do
	install -pD -m755 "dist/$i" \
		"%buildroot%_sysconfdir/control.d/facilities/$i"
done

%preun
%preun_service gpupdate

%post
%post_service gpupdate
if [ -x "/bin/systemctl" ]; then
    gpupdate-setup update
fi

# Remove storage in case we've lost compatibility between versions.
# The storage will be regenerated on GPOA start.
%define active_policy %_sysconfdir/local-policy/active
%triggerpostun -- %name < 0.9.12
rm -f %_cachedir/%name/registry.sqlite
if test -L %active_policy; then
	sed -i "s|^\s*local-policy\s*=.*|local-policy = $(readlink -f %active_policy)|" \
		%_sysconfdir/%name/%name.ini
fi

%files
%_sbindir/gpoa
%_sbindir/gpupdate-setup
%_bindir/gpupdate
%_prefix/libexec/%name/scripts_runner
%_prefix/libexec/%name/pkcon_runner
%attr(755,root,root) %python3_sitelibdir/gpoa/gpoa
%attr(755,root,root) %python3_sitelibdir/gpoa/gpupdate
%attr(755,root,root) %python3_sitelibdir/gpoa/gpupdate-setup
%attr(755,root,root) %python3_sitelibdir/gpoa/scripts_runner
%attr(755,root,root) %python3_sitelibdir/gpoa/pkcon_runner
%python3_sitelibdir/gpoa
%_datadir/%name
%_unitdir/%name.service
%_unitdir/%name-scripts-run.service
%_unitdir/%name.timer
%_man1dir/gpoa.1.*
%_man1dir/gpupdate.1.*
/usr/lib/systemd/user/%name-user.service
/usr/lib/systemd/user/%name-user.timer
/usr/lib/systemd/user/%name-scripts-run-user.service
%dir %_sysconfdir/%name
%_sysconfdir/control.d/facilities/*
%config(noreplace) %_sysconfdir/%name/environment
%config(noreplace) %_sysconfdir/%name/%name.ini
%config(noreplace) %_sysconfdir/pam.d/system-policy-%name
%config(noreplace) %_sysconfdir/pam.d/%name-remote-policy
%dir %attr(0700, root, root) %_cachedir/%name
%dir %attr(0755, root, root) %_cachedir/%{name}_file_cache
%dir %attr(0700, root, root) %_cachedir/%name/creds
%exclude %python3_sitelibdir/gpoa/.pylintrc
%exclude %python3_sitelibdir/gpoa/.prospector.yaml
%exclude %python3_sitelibdir/gpoa/Makefile
%exclude %python3_sitelibdir/gpoa/test

%changelog
