%def_disable snapshot

%def_enable ladspa
%def_enable libdc1394
%def_enable libkate
%def_enable mjpegtools
%def_enable opencv
%def_enable timidity
%def_enable vulkan
%def_enable wayland
%def_enable zbar
%def_disable rtmp

%ifarch x86_64
%def_enable openh264
%endif

%ifnarch %e2k
%def_enable liblilv
%endif

%def_disable debug
%def_enable tests
# required network
%def_disable gst_player_tests
%def_disable check

%define _name gst-plugins
%define api_ver 1.0
%define ver_major 1.16

%define _gst_libdir %_libdir/gstreamer-%api_ver
%define _gtk_docdir %_datadir/gtk-doc/html

%def_disable gtk_doc

Name: %_name-bad%api_ver
Version: %ver_major.1
Release: alt3.1

Summary: A set of GStreamer plugins that need more quality
Group: System/Libraries
License: LGPL
Url: http://gstreamer.freedesktop.org/

%if_disabled snapshot
Source: http://gstreamer.freedesktop.org/src/%_name-bad/%_name-bad-%version.tar.xz
%else
Source: %_name-bad-%version.tar
%endif

# dc57fb7095b5041e4f3a4cae2bafd56369e10212
Patch2: %_name-bad-1.17.1-up-vulkan-Drop-use-of-VK_RESULT_BEGIN_RANGE.patch
Patch3: alt-openexr-cflags.patch

Provides: %_name-bad = %version-%release

Requires: lib%_name%api_ver >= %ver_major
Requires: gstreamer%api_ver >= %ver_major

BuildRequires(pre): meson rpm-build-gir
BuildRequires: gst-plugins%api_ver-devel >= %version gst-plugins%api_ver-gir-devel
BuildRequires: bzlib-devel gcc-c++ gtk-doc libSDL-devel libX11-devel
BuildRequires: libalsa-devel libcdaudio-devel libdca-devel libdirac-devel libdvdnav-devel libexif-devel
BuildRequires: libfaad-devel libgio-devel libgsm-devel libjasper-devel libmms-devel
%{?_enable_mjpegtools:BuildRequires: libmjpegtools-devel}
BuildRequires: libmpcdec-devel libneon-devel liboil-devel libsoundtouch-devel libssl-devel libmodplug-devel
BuildRequires: libcelt-devel libxvid-devel
BuildRequires: python-module-PyXML python-modules-email python-modules-encodings python-modules-distutils
%{?_enable_timidity:BuildRequires: libtimidity-devel timidity-instruments}
%{?_enable_libkate:BuildRequires: libkate-devel libtiger-devel}
%{?_enable_libdc1394:BuildRequires: libdc1394-devel}
BuildRequires: libvpx-devel liborc-devel orc libofa-devel libmusicbrainz-devel libass-devel
%{?_enable_wayland:BuildRequires: libwayland-client-devel libwayland-cursor-devel libwayland-egl-devel wayland-protocols}
%{?_enable_zbar:BuildRequires: libzbar-devel}
BuildRequires: libEGL-devel libwebp-devel libopenjpeg2.0-devel libbluez-devel
BuildRequires: libdbus-devel libxml2-devel libgnutls-devel libvdpau-devel
BuildRequires: libsbc-devel libusb-devel libgudev-devel libopus-devel
BuildRequires: libcurl-devel libssh2-devel
BuildRequires: libvo-amrwbenc-devel librsvg-devel libvo-aacenc-devel libgcrypt-devel
BuildRequires: gobject-introspection-devel libgstreamer1.0-gir-devel
BuildRequires: libvisual0.4-devel openexr-devel libx265-devel
BuildRequires: libclutter-devel
BuildRequires: libbs2b-devel
BuildRequires: liborc-test-devel
%{?_enable_openh264:BuildRequires: libopenh264-devel >= 1.3.0}
%{?_enable_opencv:BuildRequires: libopencv-devel}
%{?_enable_ladspa:BuildRequires: ladspa_sdk liblrdf-devel libfluidsynth-devel}
%{?_enable_vulkan:BuildRequires: vulkan-devel}
%{?_enable_rtmp:BuildRequires: librtmp-devel}
# webrtc-audio-processing for webrtcdsp
BuildRequires: libwebrtc-devel >= 0.3
# since 1.13.x
BuildRequires: libnice-devel libva-devel liblcms2-devel
%{?_enable_liblilv:BuildRequires: liblilv-devel}

%description
GStreamer Bad Plug-ins is a set of plug-ins that aren't up to par
compared to the rest.  They might be close to being good quality, but
they're missing something - be it a good code review, some
documentation, a set of tests, a real live maintainer, or some actual
wide use.  If the blanks are filled in they might be upgraded to
become part of either gst-plugins-good or gst-plugins-ugly, depending
on the other factors.

%package devel
Summary: Development files for GStreamer Bad Plug-ins
Group: Development/C
Provides: %_name-bad-devel = %version-%release
Requires: %name = %version-%release

%description devel
This package contains the libraries, headers and other files necessary
to develop GStreamer Bad Plug-ins.

%package doc
Summary: Documentation for %name
Group: Documentation
BuildArch: noarch
Provides: %_name-bad-doc = %version-%release

%description doc
This package contains documentation for GStreamer Bad Plug-ins.

%prep
%setup -n %_name-bad-%version
%patch2 -p1
%patch3 -p1

%build
%meson \
	-Dexamples=disabled \
	%{?_enable_check:-Dtests=enabled} \
	%{?_disable_gtk_doc:-Dgtk_doc=disabled} \
	%{?_enable_debug:-Dgst_debug=true}

%meson_build

%install
%meson_install
%find_lang %_name-bad-%api_ver

%files -f %_name-bad-%api_ver.lang
%doc AUTHORS NEWS README RELEASE
%_libdir/*.so.*
%dir %_gst_libdir
%_gst_libdir/*.so
%_typelibdir/GstInsertBin-%api_ver.typelib
%_typelibdir/GstMpegts-%api_ver.typelib
%_typelibdir/GstPlayer-%api_ver.typelib
%_typelibdir/GstWebRTC-%api_ver.typelib
%_datadir/gstreamer-%api_ver/presets/GstVoAmrwbEnc.prs
%_datadir/gstreamer-%api_ver/presets/GstFreeverb.prs
%if_enabled opencv
#%_datadir/gst-plugins-bad/%api_ver/opencv_haarcascades/fist.xml
#%_datadir/gst-plugins-bad/%api_ver/opencv_haarcascades/palm.xml
%endif

%files devel
%_includedir/gstreamer-%api_ver/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_girdir/GstInsertBin-%api_ver.gir
%_girdir/GstMpegts-%api_ver.gir
%_girdir/GstPlayer-%api_ver.gir
%_girdir/GstWebRTC-%api_ver.gir

%if_enabled gtk_doc
%files doc
%_gtk_docdir/gst-plugins-bad-plugins-%api_ver
%_gtk_docdir/gst-plugins-bad-libs-%api_ver
%endif

%changelog
