Name: gstatus
Version: 0.64
Release: alt1

Summary: Show the current health of the component in a glusterfs Trusted Storage Pool

Group: System/Base
License: GPLv3
Url: https://github.com/pcuzner/gstatus

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/pcuzner/gstatus/archive/v%version.tar.gz
Source: %name-%version.tar

BuildArch: noarch

BuildRequires: python-devel
BuildRequires: python-module-setuptools

Requires: %_sbindir/gluster
#Requires: glusterfs >= 3.4

%description
CLI command to provide a status check on the cluster's health, providing
a view of node, volume state (up, degraded, partial or down), brick
up/down states and capacity information by volume (usable, used).

In addition to the interactive model, a json or keyvalue output option
is also available through '-o json|keyvalue'. By utilising -o, you can
log the state of the cluster to a file, and interpret with Splunk,
Logstash or nagios/zabbix.

Errors detected, are listed in plain english together and provide an
easy way to assess the impact to a service, following a disruptive event
that affects the trusted pool.

%prep
%setup

%build
%python_build

%install
%python_install --install-scripts %_bindir
#mkdir -p %buildroot%_man8dir
#install -m 0644 gstatus.8 %buildroot%_man8dir/

%files
%doc README
%_bindir/gstatus
%python_sitelibdir_noarch/gstatus/
%python_sitelibdir_noarch/gstatus-%version-*.egg-info/
#%_man8dir/gstatus.*

%changelog
