%define iname guile
%define sversion 1.8

%set_automake_version 1.11

Name: %{iname}18
Version: %sversion.7
Release: alt8
Epoch: 1

Summary: A GNU implementation of Scheme for application extensibility
License: LGPL-2.1-or-later
Group: Development/Scheme
Url: http://www.gnu.org/software/guile/

Source: ftp://alpha.gnu.org/gnu/%iname/%iname-%version.tar

Patch0: guile18-snarf-check-and-output-texi.scm.patch
Patch2: guile-1.8.7-testsuite.patch
Patch3: guile-1.8.7-testsuite2.patch
Patch4: guile-1.8.7-mkdir-umask.patch
Patch5: guile-1.8.7-overflow.patch
Patch6: guile-2.0.2-fix-read-beyond-end-of-hashtable-size-array-in-hasht.patch

BuildRequires: libgmp-devel libltdl-devel libncurses-devel libreadline-devel
BuildRequires: /proc /dev/pts

%add_findreq_skiplist %_datadir/%iname/%sversion/scripts/*

%description
GUILE (GNU's Ubiquitous Intelligent Language for Extension) is a library
implementation of the Scheme programming language, written in C.  GUILE
provides a machine-independent execution platform that can be linked in
as a library during the building of extensible programs.

%package devel
Summary: A GNU implementation of Scheme for application extensibility
Group: Development/Scheme
Requires: %name = %EVR
Requires: libgmp-devel
Conflicts: guile14-devel guile16-devel

%description devel
GUILE (GNU's Ubiquitous Intelligent Language for Extension) is a library
implementation of the Scheme programming language, written in C.  GUILE
provides a machine-independent execution platform that can be linked in
as a library during the building of extensible programs.

Install this package if you are going to develop extendable programs.

%prep
%setup -n %iname-%version
%patch0 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%__subst -p 's/^libguile_la_LDFLAGS = .*/& $(GUILE_CFLAGS)/' libguile/Makefile*

%build
%add_optflags -fwrapv
%autoreconf

%configure --with-threads --enable-error-on-warning=no --disable-static
#NO SMP
%make

%install
#export LD_LIBRARY_PATH=$RPM_BUILD_ROOT%_libdir
#make install DESTDIR=$RPM_BUILD_ROOT LDFLAGS=-L$RPM_BUILD_ROOT%_libdir
%makeinstall
#alternatives stuff
mv %buildroot%_bindir/%iname %buildroot%_bindir/%name
mv %buildroot%_man1dir/%iname.1 %buildroot%_man1dir/%name.1
sed -i '/^#!/ s,guile[[:blank:]],%name ,' %buildroot%_bindir/guile-config

%check
make check

%files
%_bindir/%name
%dir %_datadir/%iname
%dir %_datadir/%iname/%sversion
%_libdir/lib*.so.*
%_libdir/lib%iname?*.so
%_datadir/%iname/%sversion/*
%_mandir/man1/%name.1.*

%files devel
%_bindir/%iname-snarf
%_bindir/%iname-config
%_bindir/%iname-tools
%_libdir/lib%iname.so
%_includedir/*
%_datadir/aclocal/*
%_datadir/info/*.info*
%_libdir/pkgconfig/%iname-%sversion.pc

%changelog
