Name: gv
Version: 3.7.4
Release: alt2.1
Serial: 1

Packager: Stanislav Ievlev <inger@altlinux.org>

Summary: An enhanced front-end for the ghostscript PostScript(TM) interpreter
License: GPL
Group: Publishing
Url: http://www.gnu.org/software/gv/

Source: http://ftp.gnu.org/gnu/gv/%{name}-%{version}.tar.bz2

Source100: %name.png
Source101: gvcat

Requires: ghostscript-module-X >= 7.05
Provides: ghostview = %version
Obsoletes: ghostview
Requires: file

# Automatically added by buildreq on Sun Mar 27 2011 (-bi)
# optimized out: elfutils fontconfig glibc-pthread libICE-devel libSM-devel libX11-devel libXext-devel libXt-devel xorg-xproto-devel
BuildRequires: ImageMagick-tools bzlib-devel flex imake libXaw3d-devel libXinerama-devel libXmu-devel libXpm-devel xorg-cf-files zlib-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
Gv provides a user interface for the ghostscript PostScript(TM)
interpreter.  Derived from the ghostview program, %name can display
PostScript and PDF documents using the X Window System.

Install the %name package if you'd like to view PostScript and PDF documents
on your system.  You'll also need to have the ghostscript package
installed, as well as the X Window System.

%prep
%setup -q

find -type f -print0 |
	xargs -r0 %__grep -FZl 'gzip -d -c' |
	xargs -r0 %__subst 's|gzip -d -c|%_datadir/%name/gvcat|g'

find -type f -print0 |
	xargs -r0 %__grep -FZl 'gzipped, zipped or compressed' |
	xargs -r0 %__subst 's/gzipped, zipped or compressed/gzipped, bzipped, zipped or compressed/g'

find -type f -print0|
	xargs -r0 %__grep -FZl 'GraphicsAlphaBits' |
	xargs -r0 %__subst 's/-dGraphicsAlphaBits=2/-dGraphicsAlphaBits=4/g'

%build
%configure --with-scratch-dir=~/tmp/
## --enable-scrollbar-code
%make

%install
%__mkdir_p %buildroot{%_miconsdir,%_niconsdir,%_liconsdir,%_datadir/%name,%_x11bindir,%_sysconfdir/X11/app-defaults/}
%makeinstall

install -m644 %SOURCE100 -D %buildroot%_liconsdir/gv.png
convert -geometry 32x32 %SOURCE100 %buildroot%_niconsdir/gv.png
convert -geometry 16x16 %SOURCE100 %buildroot%_miconsdir/gv.png

install -p -m755 %SOURCE101 %buildroot%_datadir/%name

%__ln_s -nf %name %buildroot%_x11bindir/ghostview

install -d %buildroot/%_desktopdir
cat > %buildroot/%_desktopdir/%name.desktop <<EOF
[Desktop Entry]
Type=Application
Icon=%name
Name=Ghostview
GenericName=PostScript/PDF Viewer
GenericName[ru]=Просмотр файлов PostScript/PDF
MimeType=application/postscript;application/pdf;
Categories=Graphics;Viewer;
StartupWMClass=GV
Exec=gv %%f
EOF

mv %buildroot/%_datadir/%name/GV %buildroot%_sysconfdir/X11/app-defaults/

%files
%doc README
%config(noreplace) %_sysconfdir/X11/app-defaults/GV
%_bindir/*
%_man1dir/*
%_datadir/%name
%_desktopdir/*
%_infodir/*.info*
%_niconsdir/*.png
%_miconsdir/*.png
%_liconsdir/*.png

%changelog
