%define ver_major 1.0
%def_disable epiphany

Name: gwget
Version: %ver_major.4
Release: alt4.1

Summary: Gwget - Gnome2 wget Front-end
License: %gpl2plus
Group: Networking/File transfer
URL: http://gnome.org/projects/gwget
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar
Patch1: %name-%version-git.patch
Patch2: %name-%version-alt-fixes.patch
Patch3: %name-1.0.4-alt-glib2.patch

Provides: gwget2

BuildPreReq: rpm-build-gnome rpm-build-licenses common-licenses gnome-common
%{?_enable_epiphany:BuildRequires: epiphany-devel}
BuildRequires: gcc-c++ libgnomeui-devel libnotify-devel intltool
BuildRequires: libgtk+2-devel libdbus-glib-devel
BuildRequires: zlib-devel libGConf-devel
BuildRequires: libgio-devel >= 2.16.0

Requires: wget

%description
Gwget: Gnome2 wget Front-end.
Gwget it's a download manager for the Gnome Desktop. The main features are: 
* Resume: By default, gwget tries to continue any download.
* Notification: Gwget tries to use the Gnome notification area support, 
  if available. You can close the main window and gwget runs in the background.
* Recursivity: Gwget detects when you put a html, php, asp or a web page dir 
  in the url to download, and ask you 
  to only download certain files (multimedia, only the index, and so on).
* Drag & Drop: You can d&d a url to the main gwget window or 
  the notification area icon to add a new download. 

%if_enabled epiphany

%package -n epiphany-extension-gwget
Summary: Gwget extention for Epiphany browser
Group: Networking/File transfer
Requires:       %name = %version-%release
Requires:       epiphany epiphany-extensions
BuildRequires: epiphany-devel

%description -n epiphany-extension-gwget
Extention Gwget for Epiphany browser
%endif

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p0

rm -f COPYING
ln -s %_licensedir/GPL-2 COPYING

%build
./autogen.sh
%configure  \
%if_enabled epiphany
	--enable-epiphany-extension \
%endif
	--disable-static \
	--disable-schemas-install

%make_build

%install
%make_install install DESTDIR=%buildroot

# remove none-packaged files
%__rm -f %buildroot%_libdir/epiphany/*/extensions/*.{a,la}

%find_lang --with-gnome %name 

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
    %gconf2_uninstall %name
fi

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README TODO
%doc --no-dereference COPYING
%_bindir/*
%_datadir/%name
%_datadir/pixmaps/*
%_datadir/applications/*
%config %_sysconfdir/gconf/schemas/*
%_datadir/dbus-1/services/*.service

%if_enabled epiphany
%files -n epiphany-extension-gwget
%_libdir/epiphany/*/extensions/*
%endif

%changelog
