Name: havp
Version: 0.93
Release: alt1

Summary: (HTTP Antivirus Proxy) is a proxy with anti-virus scanner

License: GPL-2.0-only
Group: System/Servers

Url: http://www.havp.org/
Source: http://www.havp.org/download/%name-%version.tar.gz
Source1: havp.init
Source2: havp_spool_disk.config
Source3: havp_README.ALT.txt

Patch0: havp-0.93-alt.patch

Summary(ru_RU.UTF8): Прокси сервер с антивирусным сканированием трафика

Requires: clamav-freshclam

BuildPreReq: libssl-devel zlib-devel
# Automatically added by buildreq on Wed Jun 13 2007
BuildRequires: gcc-c++ libclamav-devel

%description
The main aims are continuous, non-blocking downloads and smooth scanning 
of dynamic and password protected HTTP traffic. Havp antivirus proxy has 
a parent and transparent proxy mode. It can be used with squid or standalone.

%description -l ru_RU.UTF8
Основная цель: - прозрачное антивирусное сканирование HTTP трафика.
Может работать как родительский или прозрачный прокси сервер.
Может использоваться со сквидом или автономно.
Поддерживает такие антивирусы:
 - ClamAV through libclamav (используется по умолчанию)
 - ClamAV through clamd
 - Kaspersky (aveserver daemon)
 - Trend Micro (Trophie)
 - AVG
 - F-Prot
 - NOD32
 - Sophos (необходима пересборка с библиотекой)
 
%prep
%setup -q
%patch0 -p1

find %_builddir/%name-%version/etc/%name -type d -print0 | xargs -r0 chmod 755
find %_builddir/%name-%version/etc/%name -type f -print0 | xargs -r0 chmod 644

%build
%configure --localstatedir=/var --enable-ssl-tunnel
%make_build

%install
%make DESTDIR=%buildroot install
%__mkdir_p %buildroot%_logdir/%name
%__mkdir_p %buildroot%_spooldir/%name
%__mkdir_p %buildroot%_var/run/%name
%__mkdir_p %buildroot%_initrddir
%__mkdir_p %buildroot%_sysconfdir/logrotate.d


%__install -p -m 755 %SOURCE1  %buildroot%_initrddir/havp
%__install -p -m 640 etc/havp/havp.config %buildroot%_sysconfdir/%name/havp.config
%__install -p -m 640 %SOURCE2  %buildroot%_sysconfdir/%name/spool_disk.config
%__install -p -m 644 %SOURCE3  README.ALT

%__cat << EOF > %buildroot%_sysconfdir/logrotate.d/havp
/var/log/havp/access.log {
    create 644 root havp
    weekly
    rotate 5
    copytruncate
    compress
    notifempty
    missingok
}
/var/log/havp/havp.log {
    create 644 root havp
    weekly
    rotate 5
    copytruncate
    compress
    notifempty
    missingok
    postrotate
        /sbin/service havp reload >/dev/null
    endscript
}
EOF


%pre
/usr/sbin/groupadd -r -f %name &> /dev/null ||:
/usr/sbin/useradd -r -g %name -d /dev/null -c 'Proxy with antivirus scan' -s /dev/null -n %name &> /dev/null ||:

%post
%post_service %name

%preun
%preun_service %name

%postun

%files
%doc ChangeLog INSTALL COPYING README.ALT
%_sbindir/*
%config %_initrddir/%name
%config %_sysconfdir/logrotate.d/*
%_sysconfdir/%name/%name.config.default
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/%name/%name.config
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/%name/spool_disk.config
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/%name/whitelist
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/%name/blacklist
%config(noreplace) %verify(not md5 size mtime) %_sysconfdir/%name//templates/*/*
%dir %_sysconfdir/%name/templates
%dir %_sysconfdir/%name/templates/*
%dir %attr(750,root,%name) %_sysconfdir/%name
%dir %attr(775,root,%name) %_var/run/%name
%dir %attr(2770,root,%name) %_spooldir/%name
%dir %attr(3770,%name,root) %_logdir/%name

%changelog
