Name: help2man
Version: 1.47.10
Release: alt1

Summary: help2man creates simple man pages from the output of programs
License: GPLv3+
Group: Development/Other
Url: https://www.gnu.org/software/help2man/

%def_enable nls

# NLS support makes whole package arch-specific.
%{?!_enable_nls:BuildArch: noarch}

# https://ftp.gnu.org/gnu/help2man/%name-%version.tar.xz
Source: help2man-%version.tar
Patch: help2man-1.40.4-alt-runas.patch

Requires: coreutils

%if_enabled nls
%define lib_suffix %nil
%{expand:%%define lib_suffix %(test %_lib != lib64 && echo %%nil || echo '()(64bit)')}
Requires: preloadable_libintl.so%lib_suffix
BuildRequires: perl-Locale-gettext
%endif

%description
help2man is a tool for automatically generating simple manual
pages from program output.

This program is intended to provide an easy way for software authors
to include a manual page in their distribution without having to
maintain that document.

Given a program which produces reasonably standard --help and
--version outputs, help2man can re-arrange that output into
something which resembles a manual page.

%prep
%setup
%patch -p1
install -pm644 debian/README README.example
sed -i '1i .\\" -*- mode: troff; coding: utf8 -*-' help2man.*.1

%build
%{?_enable_nls:test -r %_libdir/preloadable_libintl.so}
%configure %{subst_enable nls}
%make_build

%install
%makeinstall_std
%find_lang --with-man help2man

%files -f help2man.lang
%if_enabled nls
%_libdir/%name
%endif
%_bindir/*
%_man1dir/*
%_infodir/*.info*
%doc ChangeLog NEWS README* THANKS help2man.h2m

%changelog
