%define nuserui tuxonice-userui-1.0

Name: hibernate-script
Version: 2.0
Release: alt3.qa1

Summary: Software suspend 2 hibernate script
License: GPL
Group: System/Kernel and hardware
URL: http://www.tuxonice.net/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Provides: hibernate = %version hibernate-cleanup = %version
Requires: util-linux >= 2.16
Obsoletes: hibernate < %version-%release hibernate-cleanup < %version-%release
Conflicts: pm-utils

Source0: http://www.tuxonice.net/downloads/all/%name-%version.tar.gz
Source1: http://www.tuxonice.net/downloads/all/%nuserui.tar.gz
Source2: hibernate-cleanup

Patch1: hibernate-script-2.0-alt-defaults.patch
Patch2: hibernate-script-2.0-alt-cleanup.patch
Patch3: hibernate-script-2.0-alt-pause-cmus.patch

Patch10: hibernate-script-2.0-alt-tuxonice-userui.patch

%description
hibernate is a shell script that handles the process of getting ready
to suspend to disk and to resume from disk. It requires the Software
Suspend 2 patches available at http://www.tuxonice.net/.
After installing you will want to run 'hibernate -h' to see available
options and modify your /etc/hibernate/hibernate.conf to set them.
This package includes %nuserui in the installation.

%prep
%setup -q -a1

%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch10 -p1

find -type f -exec chmod -x {} \;

%build
pushd %nuserui
%make clean
%make tuxoniceui_text CFLAGS="%optflags -O2"
popd

%install
export 	BASE_DIR=%buildroot \
	PREFIX=%_prefix \
	MAN_DIR=%buildroot%_mandir

sh install.sh

unset BASE_DIR PREFIX MAN_DIR SCRIPTLET_DIR

mkdir -p %buildroot%_sysconfdir/{logrotate.d,rc.d/scripts,rc.d/init.d}
install -m644 logrotate.d-hibernate-script %buildroot%_sysconfdir/logrotate.d/hibernate
install -m755 %nuserui/tuxoniceui_text %buildroot%_sbindir
install -m755 init.d/hibernate-cleanup.sh %buildroot%_sysconfdir/rc.d/scripts/
install -m755 %SOURCE2 %buildroot%_initdir/
ln -sf hibernate %buildroot%_sbindir/pm-hibernate

mkdir -p doc/%nuserui
cp -a README CHANGELOG SCRIPTLET-API admin doc/
cp -a %nuserui/{KERNEL_API,USERUI_API,ChangeLog,README,TODO} doc/%nuserui/

> %buildroot%_sysconfdir/hibernate/blacklisted-modules
mkdir -p %buildroot%_sysconfdir/hibernate/scriptlets.d

cat <<__EOF__> %buildroot%_sbindir/pm-suspend
#!/bin/sh

%_sbindir/hibernate -F %_sysconfdir/hibernate/ram.conf
exit \$?
__EOF__

%post
%post_service hibernate-cleanup

%preun
%preun_service hibernate-cleanup

%files
%doc doc/*
%attr(0755,root,root) %_sysconfdir/rc.d/scripts/*
%attr(0755,root,root) %_initdir/*
%dir %_sysconfdir/hibernate
%config(noreplace) %_sysconfdir/hibernate/*.conf
%config(noreplace) %_sysconfdir/hibernate/blacklisted-modules
%dir %_sysconfdir/hibernate/scriptlets.d
%_datadir/hibernate
%_sysconfdir/logrotate.d/hibernate
%attr(0755,root,root) %_sbindir/*
%_man5dir/*.5*
%_man8dir/*.8*

%changelog
