Name: hydrogen
Version: 0.9.7
Release: alt1

Summary: Hydrogen Drum Machine
License: GPL
Group: Sound
URL: http://www.hydrogen-music.org

# https://github.com/hydrogen-music/hydrogen.git
Source0: %name-%version.tar
Source1: %name-32x32.xpm
Source2: %name-16x16.xpm
Source3: %name-48x48.xpm
Patch1: %name-%version-upstream-detect-pulse.patch
Patch2: %name-%version-upstream-detect-rubberband.patch
Patch3: %name-%version-alt-desktop.patch
Patch4: %name-%version-alt-man-dir.patch

BuildRequires: ccmake ctest doxygen gcc-c++ graphviz ladspa_sdk libalsa-devel libarchive-devel libjack-devel liblo liblrdf-devel
BuildRequires: libportaudio2-devel libportmidi librubberband-devel libsndfile-devel libtar-devel libpulseaudio-devel cppunit-devel
BuildRequires: libqt4-sql-mysql phonon-devel

BuildRequires: desktop-file-utils

%description
Hydrogen is a sample based drum machine with:
 Graphical user interface based on QT 
 Sample based real-time audio engine
 Oss Audio driver
 Jack Audio driver
 Export to disk audio driver
 Alsa Midi input
 Ability to import/export xml-based song file
 64 ticks per pattern
 16 voices with volume, mute, solo, pan capabilities
 Import of samples in wav, au, aiff format

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
export QTDIR=%_libdir/qt4
%cmake -DWANT_RUBBERBAND=ON
%cmake_build DESTDIR=%buildroot

%install
export QTDIR=%_libdir/qt4
%cmakeinstall_std prefix=%_prefix

install -pD -m644 %SOURCE1 %buildroot%_niconsdir/%name.xpm
install -pD -m644 %SOURCE2 %buildroot%_miconsdir/%name.xpm
install -pD -m644 %SOURCE3 %buildroot%_liconsdir/%name.xpm

desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Midi \
	%buildroot%_desktopdir/hydrogen.desktop

%files
%doc -P AUTHORS ChangeLog README.txt
%_bindir/*
%_datadir/%name/
%_libdir/*.so
%_niconsdir/%name.xpm
%_liconsdir/%name.xpm
%_miconsdir/%name.xpm
%_desktopdir/%name.desktop
%_man1dir/%name.1*

%changelog
