%def_with python3
%def_with doc

Name: ipython
Version: 5.5.0
Release: alt3

%setup_python_module IPython

Summary: An enhanced interactive Python shell
License: BSD
Group: Development/Python

Url: http://ipython.org
BuildArch: noarch

# https://github.com/ipython/ipython.git
Source: %name-%version.tar
Patch0: %name-0.10-alt-bindings-fix.patch
Patch1: %name-%version-alt-docs.patch

%add_findreq_skiplist %python_sitelibdir/IPython/utils/eventful.py
%add_findreq_skiplist %python3_sitelibdir/IPython/utils/eventful.py

BuildRequires: python-module-setuptools pyjsdoc
BuildRequires: python-module-zmq
BuildRequires: python-module-tornado python-modules-sqlite3
BuildRequires: python-module-jsonschema python-module-traitlets
BuildRequires: python-module-pexpect python-module-pickleshare
BuildRequires: python-module-simplegeneric python-module-ipykernel
BuildRequires: python-module-ipyparallel
BuildRequires: python2.7(pathlib2)
BuildRequires: python2.7(prompt_toolkit)
BuildRequires: python2.7(nose.tools)
BuildRequires: python-module-testpath
%if_with doc
BuildRequires: python-module-sphinx-devel python-module-matplotlib-sphinxext python-module-numpydoc
BuildRequires: python2.7(sphinx_rtd_theme) graphviz
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-traitlets python3-module-tornado
BuildRequires: python3-module-pexpect python3-module-pickleshare
BuildRequires: python3-module-simplegeneric python3-module-ipykernel
BuildRequires: python3-module-ipyparallel
BuildRequires: python3(pathlib)
BuildRequires: python3(prompt_toolkit)
BuildRequires: python3(nose.tools)
BuildRequires: python3-module-testpath
%endif

%add_python_req_skip Gnuplot Numeric bzrlib foolscap nose setuptools twisted msvcrt oct2py rpy2 System builtins clr
%add_python3_req_skip __main__
%py_requires jsonschema traitlets pexpect simplegeneric ipykernel
%py_requires ipyparallel
%py_requires pathlib2


%description
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.

%if_with python3
%package -n %{name}3
Summary: An enhanced interactive Python 3 shell
Group: Development/Python3
%add_python3_req_skip Gnuplot Numeric bzrlib foolscap nose setuptools twisted
%add_python3_req_skip msvcrt wx gtk compiler OpenGL oct2py rpy2
%add_python3_req_skip System clr
%py3_requires jsonschema traitlets pexpect simplegeneric ipykernel
%py3_requires ipyparallel
%py3_requires pathlib

%description -n %{name}3
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.
%endif


%package doc
Summary: IPython documentation
Group: Development/Python

%description doc
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains IPython documentation (html and PDF formats).


%package examples
Summary: IPython examples
Group: Development/Python

%description examples
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains examples for IPython.


%prep
%setup
%patch1 -p1

%if_with python3
cp -a . ../python3
%endif

%if_with doc
%prepare_sphinx docs
ln -s ../objects.inv docs/source/
%endif

%build
%python_build
%if_with python3
pushd ../python3
export LANG="en_US.UTF-8"
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
export LANG="en_US.UTF-8"
%python3_install
rm -r %buildroot%python3_sitelibdir/IPython/*/tests
rm %buildroot%_bindir/iptest3
popd
pushd %buildroot%_bindir
for i in $(ls)
do
	mv $i ${i}3
done
mv ipython33 ipython3
popd
%endif

%python_install
rm -r %buildroot%python_sitelibdir/IPython/*/tests
rm %buildroot%_bindir/iptest

%if_with doc
install -d %buildroot%_docdir/%name
cp docs/source/*.txt %buildroot%_docdir/%name/

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs html
cp -R docs/build/html/* examples %buildroot%_docdir/%name/
%endif

%files
%_bindir/*
%if_with python3
%exclude %_bindir/*3
%endif
%_man1dir/*
%if_with doc
%dir %_docdir/%name
%_docdir/%name/*.txt
%endif
%python_sitelibdir/IPython/
%python_sitelibdir/*.egg-info

%if_with doc
%files doc
%_docdir/%name
%exclude %_docdir/%name/*.txt
%exclude %_docdir/%name/examples
#_docdir/%name/manual/

%files examples
%dir %_docdir/%name
%_docdir/%name/examples
%endif

%if_with python3
%files -n %{name}3
%_bindir/*3
%python3_sitelibdir/*
%endif

%changelog
