Name: irqbalance
Version: 1.5.0
Release: alt1

Summary: Evenly distribute interrupt load across CPUs
License: GPLv2
Group: System/Kernel and hardware

Url: https://github.com/Irqbalance/irqbalance
Source: %name-%version.tar

BuildRequires: gccmakedep glib2-devel libcap-ng-devel libnuma-devel libncurses-devel

%define sysconfig %_sysconfdir/sysconfig/%name

%description
irqbalance distributes interrupts over the processors and cores
you have in your computer system. The design goal of irqbalance
is to do find a balance between power savings and optimal
performance. To a large degree, the work irqbalance does is
invisible to you; if irqbalance performs its job right, nobody
will ever notice it's there or want to turn it off.

%prep
%setup
sed -i "s|/path/to/irqbalance.env|%sysconfig|g" misc/%name.service

%build
mkdir -p m4
%autoreconf
%configure
%make_build

%install
%makeinstall_std
install -pDm755 %name.init %buildroot%_initdir/%name
install -pDm644 misc/%name.env %buildroot%sysconfig
install -pDm644 misc/%name.service %buildroot%systemd_unitdir/%name.service

%preun
%preun_service %name

%post
%post_service %name

%files
%doc AUTHORS COPYING
%_sbindir/%name
%_sbindir/%name-ui
%config(noreplace) %sysconfig
%_initdir/%name
%_man1dir/%name.1*
%systemd_unitdir/%name.service

%changelog
