%def_enable largefile
%define _sbindir /sbin

Name: jfsutils
Version: 1.1.15
Release: alt2
Summary: IBM JFS utility programs
License: GPLv2+
Group: System/Kernel and hardware
Url: http://jfs.sourceforge.net
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Provides: jfsprogs = %version-%release
Obsoletes: jfsprogs

BuildRequires: libuuid-devel

%description
IBM's journaled file system technology, currently used in IBM enterprise servers,
is designed for high-throughput server environments, key to running intranet and
other high-performance e-business file servers.

%description -l ru_RU.UTF-8
Технология журналируемой файловой системы IBM, в настоящее время используется на
enterprise-серверах IBM, разработана для высокопроизводительных серверных
окружений, ключ к работающим intranet- и другим высокопроизводительным файловым
серверам электронной коммерции.

%description -l uk_UA.UTF-8
Технологія журнальованої файлової системи IBM, яка нині використовується на
enterprise-серверах IBM, розроблена для високопродуктивних серверних оточень,
є ключом до працюючих intranet- та інших високопродуктивних файлових серверів
електронної комерції.


%prep
%setup -q
%patch -p1


%build
%autoreconf
%configure --enable-largefile
%make_build
for n in NEWS ChangeLog; do
	gzip -9c $n > $n.gz
done


%install
%makeinstall_std
for n in fsck mkfs; do
	ln -sf jfs_$n %buildroot/sbin/$n.jfs
	ln -sf jfs_$n.8 %buildroot/%_man8dir/$n.jfs.8
done


%files
%doc AUTHORS ChangeLog.* NEWS.* README
%_sbindir/*
%_man8dir/*


%changelog
